/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.surf.core.processor.ProcessorExtension;
import org.springframework.extensions.webscripts.MultiScriptLoader;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.processor.BaseRegisterableScriptProcessor;

public abstract class AbstractScriptProcessor
extends BaseRegisterableScriptProcessor
implements ApplicationContextAware,
ScriptProcessor {
    private SearchPath searchPath;
    private ScriptLoader scriptLoader;

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    protected SearchPath getSearchPath() {
        return this.searchPath;
    }

    protected ScriptLoader getScriptLoader() {
        return this.scriptLoader;
    }

    protected void addProcessorModelExtensions(Object model) {
        if (model == null) {
            model = new HashMap();
        }
        if (model instanceof Map) {
            for (ProcessorExtension ex : this.processorExtensions.values()) {
                ((Map)model).put(ex.getExtensionName(), ex);
            }
        }
    }

    protected void initLoaders() {
        ArrayList<ScriptLoader> loaders = new ArrayList<ScriptLoader>(this.searchPath.getStores().size());
        for (Store apiStore : this.searchPath.getStores()) {
            ScriptLoader loader = apiStore.getScriptLoader();
            if (loader == null) {
                throw new WebScriptException("Unable to retrieve script loader for Web Script store " + apiStore.getBasePath());
            }
            loaders.add(loader);
        }
        this.scriptLoader = new MultiScriptLoader(loaders.toArray(new ScriptLoader[loaders.size()]));
    }

    @Override
    public void init() {
        this.initLoaders();
    }

    @Override
    public void register() {
        this.getScriptProcessorRegistry().registerScriptProcessor(this);
    }
}

