/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;

public class SimpleCredentialVault
implements CredentialVault,
Serializable {
    protected final String id;
    protected final Map<String, Credentials> credentialsMap = new HashMap<String, Credentials>(8, 1.0f);
    protected final RemoteConfigElement remote;

    public SimpleCredentialVault(String id, RemoteConfigElement remote) {
        this.id = id;
        this.remote = remote;
    }

    @Override
    public void store(Credentials credentials) {
        this.credentialsMap.put(credentials.getEndpointId(), credentials);
    }

    @Override
    public Credentials retrieve(String endpointId) {
        Credentials credentials = this.credentialsMap.get(endpointId);
        if (credentials == null) {
            RemoteConfigElement.EndpointDescriptor desc = this.remote.getEndpointDescriptor(endpointId);
            if (desc == null) {
                throw new IllegalArgumentException("Unknown endpoint ID: " + endpointId);
            }
            String remapId = desc.getParentId();
            if (remapId != null) {
                credentials = this.credentialsMap.get(remapId);
            }
        }
        return credentials;
    }

    @Override
    public void remove(String endpointId) {
        this.credentialsMap.remove(endpointId);
    }

    @Override
    public boolean hasCredentials(String endpointId) {
        return this.retrieve(endpointId) != null;
    }

    @Override
    public String[] getStoredIds() {
        return this.credentialsMap.keySet().toArray(new String[this.credentialsMap.size()]);
    }

    @Override
    public Credentials newCredentials(String endpointId) {
        CredentialsImpl credentials = new CredentialsImpl(endpointId);
        this.store(credentials);
        return credentials;
    }

    public String toString() {
        return "SimpleCredentialVault - " + this.id;
    }
}

