/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.AuthenticationException;
import org.springframework.extensions.webscripts.connector.AbstractAuthenticator;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class AlfrescoAuthenticator
extends AbstractAuthenticator {
    private static Log logger = LogFactory.getLog(AlfrescoAuthenticator.class);
    private static final String JSON_LOGIN = "'{'\"username\": \"{0}\", \"password\": \"{1}\"'}'";
    private static final String API_LOGIN = "/api/login";
    private static final String MIMETYPE_APPLICATION_JSON = "application/json";
    public static final String CS_PARAM_ALF_TICKET = "alfTicket";

    @Override
    public ConnectorSession authenticate(String endpoint, Credentials credentials, ConnectorSession connectorSession) throws AuthenticationException {
        String pass;
        String user;
        ConnectorSession cs = null;
        if (credentials != null && (user = (String)credentials.getProperty("cleartextUsername")) != null && (pass = (String)credentials.getProperty("cleartextPassword")) != null) {
            String endpointId = credentials.getEndpointId();
            RemoteConfigElement config = this.getConnectorService().getRemoteConfig();
            RemoteConfigElement.EndpointDescriptor desc = config.getEndpointDescriptor(endpointId);
            if (desc == null) {
                throw new IllegalArgumentException("Unknown endpoint ID: " + endpointId);
            }
            RemoteClient remoteClient = this.buildRemoteClient(config.getEndpointDescriptor(endpointId).getEndpointUrl());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticating user: " + user));
            }
            remoteClient.setRequestContentType(MIMETYPE_APPLICATION_JSON);
            String body = MessageFormat.format(JSON_LOGIN, JSONWriter.encodeJSONString(user), JSONWriter.encodeJSONString(pass));
            Response response = remoteClient.call(this.getLoginURL(), body);
            if (response.getStatus().getCode() == 200) {
                String ticket;
                try {
                    JSONObject json = new JSONObject(response.getResponse());
                    ticket = json.getJSONObject("data").getString("ticket");
                }
                catch (JSONException jErr) {
                    throw new AuthenticationException("Unable to retrieve login ticket from Alfresco", (Exception)((Object)jErr));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Parsed ticket: " + ticket));
                }
                if (connectorSession != null) {
                    connectorSession.setParameter(CS_PARAM_ALF_TICKET, ticket);
                    cs = connectorSession;
                }
            } else if (response.getStatus().getCode() == 204) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"SC_NO_CONTENT(204) status received - retreiving auth cookies...");
                }
                this.processResponse(response, connectorSession);
                cs = connectorSession;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication failed, received response code: " + response.getStatus().getCode()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No user credentials available - cannot authenticate.");
        }
        return cs;
    }

    @Override
    public boolean isAuthenticated(String endpoint, ConnectorSession connectorSession) {
        return connectorSession.getParameter(CS_PARAM_ALF_TICKET) != null || connectorSession.getCookieNames().length != 0;
    }

    protected String getLoginURL() {
        return API_LOGIN;
    }
}

