/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptRequestImpl;

public abstract class WebScriptRequestURLImpl
extends WebScriptRequestImpl {
    protected String contextPath;
    protected String servletPath;
    protected String pathInfo;
    protected String queryString;
    protected Map<String, String> queryArgs;
    protected Map<String, List<String>> queryArgsMulti;
    protected Match serviceMatch;
    private String[] paramNames = null;

    public static String[] splitURL(String scriptUrl) {
        String queryString;
        String path;
        String[] urlParts = new String[4];
        int argsIndex = scriptUrl.indexOf("?");
        if (argsIndex != -1) {
            path = scriptUrl.substring(0, argsIndex);
            queryString = scriptUrl.substring(argsIndex + 1);
        } else {
            path = scriptUrl;
            queryString = null;
        }
        String[] pathSegments = path.split("/");
        Object pathInfo = "";
        for (int i = 3; i < pathSegments.length; ++i) {
            pathInfo = (String)pathInfo + "/" + pathSegments[i];
        }
        urlParts[0] = "/" + pathSegments[1];
        urlParts[1] = "/" + pathSegments[2];
        urlParts[2] = pathInfo;
        urlParts[3] = queryString;
        return urlParts;
    }

    public static String[] splitURL(String context, String scriptUrl) {
        String queryString;
        String path;
        String[] urlParts = new String[4];
        int argsIndex = scriptUrl.indexOf("?");
        if (argsIndex != -1) {
            path = scriptUrl.substring(0, argsIndex);
            queryString = scriptUrl.substring(argsIndex + 1);
        } else {
            path = scriptUrl;
            queryString = null;
        }
        String[] pathSegments = path.substring(context.length() + 1).split("/");
        StringBuilder pathInfo = new StringBuilder(64);
        for (int i = 1; i < pathSegments.length; ++i) {
            pathInfo.append('/').append(pathSegments[i]);
        }
        urlParts[0] = context;
        urlParts[1] = "/" + pathSegments[0];
        urlParts[2] = pathInfo.toString();
        urlParts[3] = queryString;
        return urlParts;
    }

    public WebScriptRequestURLImpl(Runtime runtime, String scriptUrl, Match serviceMatch) {
        this(runtime, WebScriptRequestURLImpl.splitURL(scriptUrl), serviceMatch);
    }

    public WebScriptRequestURLImpl(Runtime runtime, String[] scriptUrlParts, Match serviceMatch) {
        super(runtime);
        this.contextPath = scriptUrlParts[0];
        this.servletPath = scriptUrlParts[1];
        this.pathInfo = scriptUrlParts[2];
        this.queryString = scriptUrlParts[3];
        this.queryArgs = new HashMap<String, String>(8, 1.0f);
        this.queryArgsMulti = new HashMap<String, List<String>>(4, 1.0f);
        if (this.queryString != null) {
            String[] args;
            for (String arg : args = this.queryString.split("&")) {
                String[] parts = arg.split("=");
                if (this.queryArgs.containsKey(parts[0])) {
                    List<String> values = this.queryArgsMulti.get(parts[0]);
                    if (values == null) {
                        values = new ArrayList<String>(4);
                        this.queryArgsMulti.put(parts[0], values);
                    }
                    values.add(parts.length == 2 ? parts[1] : WebScriptRequestURLImpl.joinParts(parts));
                    continue;
                }
                this.queryArgs.put(parts[0], parts.length == 2 ? parts[1] : WebScriptRequestURLImpl.joinParts(parts));
            }
        }
        Set<String> keys = this.queryArgs.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        this.paramNames = names;
        this.serviceMatch = serviceMatch;
    }

    public String toString() {
        return "Request Service Match: " + String.valueOf(this.serviceMatch) + " URL: " + this.contextPath + this.servletPath + this.pathInfo + "?" + this.queryString;
    }

    @Override
    public Match getServiceMatch() {
        return this.serviceMatch;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getServiceContextPath() {
        return this.getContextPath() + this.servletPath;
    }

    @Override
    public String getServicePath() {
        return this.getServiceContextPath() + this.pathInfo;
    }

    @Override
    public String getURL() {
        return this.getServicePath() + (String)(this.queryString != null ? "?" + this.queryString : "");
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String[] getParameterNames() {
        return this.paramNames;
    }

    @Override
    public String getParameter(String name) {
        return this.queryArgs.get(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> values = this.queryArgsMulti.get(name);
        if (values != null) {
            String[] array = new String[values.size()];
            values.toArray(array);
            return array;
        }
        String value = this.queryArgs.get(name);
        if (value != null) {
            return new String[]{value};
        }
        return null;
    }

    private static String joinParts(String[] parts) {
        StringBuilder buf = new StringBuilder(parts.length << 4);
        for (int i = 1; i < parts.length; ++i) {
            if (i != 1) {
                buf.append('=');
            }
            buf.append(parts[i] != null ? parts[i] : "");
        }
        return buf.toString();
    }
}

