/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.extensions.webscripts.WebScriptException;

public class UriTemplate {
    private static final Pattern VALID_URI = Pattern.compile("^/(([\\w\\-]+|\\{([a-zA-Z][\\w]*)\\})(;*)/?)+(\\.\\w+$)?|^/$");
    private static final Pattern VARIABLE = Pattern.compile("\\{([a-zA-Z]\\w*)\\}");
    private static final String VARIABLE_REGEX = "(.*?)";
    private String template;
    private Pattern regex;
    private String[] vars;
    private int charCnt;

    public UriTemplate(String template) {
        if (template == null || template.length() == 0) {
            throw new WebScriptException("URI Template not provided");
        }
        Matcher validMatcher = VALID_URI.matcher(template);
        if (!validMatcher.matches()) {
            throw new WebScriptException("URI Template malformed: " + template);
        }
        StringBuilder templateRegex = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        int charCnt = 0;
        int start = 0;
        int end = 0;
        Matcher matcher = VARIABLE.matcher(template);
        while (matcher.find()) {
            end = matcher.start();
            charCnt += this.appendTemplate(template, start, end, templateRegex);
            templateRegex.append(VARIABLE_REGEX);
            String name = matcher.group(1);
            names.add(name);
            start = matcher.end();
        }
        this.template = template;
        this.charCnt = charCnt += this.appendTemplate(template, start, template.length(), templateRegex);
        this.regex = Pattern.compile(templateRegex.toString());
        this.vars = new String[names.size()];
        names.toArray(this.vars);
    }

    private int appendTemplate(String template, int start, int end, StringBuilder regex) {
        for (int i = start; i < end; ++i) {
            char c = template.charAt(i);
            if ("(.?)".indexOf(c) != -1) {
                regex.append("\\");
            }
            regex.append(c);
        }
        return end - start;
    }

    public Map<String, String> match(String uri) {
        Matcher m;
        HashMap<String, String> values = null;
        if (uri != null && uri.length() != 0 && (m = this.regex.matcher(uri)).matches()) {
            values = new HashMap<String, String>(m.groupCount(), 1.0f);
            for (int i = 0; i < m.groupCount(); ++i) {
                String name = this.vars[i];
                String value = m.group(i + 1);
                String existingValue = (String)values.get(name);
                if (existingValue != null && !existingValue.equals(value)) {
                    return null;
                }
                values.put(this.vars[i], value);
            }
        }
        return values;
    }

    public String getTemplate() {
        return this.template;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String[] getVariableNames() {
        return this.vars;
    }

    public int getStaticCharCount() {
        return this.charCnt;
    }

    public final String toString() {
        Object strVars = "";
        for (int i = 0; i < this.vars.length; ++i) {
            strVars = (String)strVars + this.vars[i];
            if (i >= this.vars.length - 1) continue;
            strVars = (String)strVars + ",";
        }
        return this.regex.toString() + " (vars=[" + (String)strVars + "])";
    }

    public final int hashCode() {
        return this.regex.hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof UriTemplate)) {
            return false;
        }
        return this.regex.equals(((UriTemplate)obj).regex);
    }
}

