/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;

@ScriptClass(help="Provides functions to aid debugging of scripts.", code="logger.log(\"Command Processor: isEmailed=\" + isEmailed);", types={ScriptClassType.JavaScriptRootObject})
public final class ScriptLogger {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.repo.jscript.ScriptLogger");
    private static final SystemOut systemOut = new SystemOut();

    @ScriptMethod(help="Returns true if logging is enabled.", code="var loggerStatus = logger.isLogginEnabled();", output="true if logging is enabled")
    public boolean isLoggingEnabled() {
        return logger.isDebugEnabled();
    }

    @ScriptMethod(help="Logs a message")
    public void log(@ScriptParameter(help="Message to log") String str) {
        logger.debug((Object)str);
    }

    @ScriptMethod(help="Returns true if warn logging is enabled.", code="var loggerStatus = logger.isWarnLogginEnabled();", output="true if warn logging is enabled")
    public boolean isWarnLoggingEnabled() {
        return logger.isWarnEnabled();
    }

    @ScriptMethod(help="Logs a warning message")
    public void warn(@ScriptParameter(help="Message to log") String str) {
        logger.warn((Object)str);
    }

    public SystemOut getSystem() {
        return systemOut;
    }

    public static class SystemOut {
        public void out(String str) {
            System.out.println(str);
        }
    }
}

