/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescriptionDocument;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.ResourceDescription;

public class PackageDescriptionDocument
extends AbstractBaseDescriptionDocument {
    public static final String ROOT_ELEMENT_NAME = "package";
    public static final String RESOURCES_ELEMENT_NAME = "resources";
    public static final String DESC_NAME_POSTFIX = "package-desc.xml";
    public static final String DESC_NAME_PATTERN = "package-desc.xml";
    private Path scriptPackage;
    private ArrayList<ResourceDescription> resourceDescriptionList = new ArrayList();

    public void setPackage(Path scriptPackage) {
        this.scriptPackage = scriptPackage;
    }

    public Path getPackage() {
        return this.scriptPackage;
    }

    public ArrayList<ResourceDescription> getResourceDescriptionList() {
        return this.resourceDescriptionList;
    }

    public void setResourceDescriptionList(ArrayList<ResourceDescription> resourceDescriptionList) {
        this.resourceDescriptionList = resourceDescriptionList;
    }

    public ResourceDescription[] getResourceDescriptions() {
        return this.resourceDescriptionList.toArray(new ResourceDescription[this.resourceDescriptionList.size()]);
    }

    public void setResourceDescriptions(ResourceDescription[] resourceDescriptions) {
        this.resourceDescriptionList = new ArrayList();
        Collections.addAll(this.resourceDescriptionList, resourceDescriptions);
    }

    public void addResourceDescription(ResourceDescription resouceDescription) {
        this.resourceDescriptionList.add(resouceDescription);
    }

    @Override
    public void parse(Element elem) {
        if (this.validateRootElement(elem, ROOT_ELEMENT_NAME)) {
            super.parse(elem);
            this.resourceDescriptionList = new ArrayList();
            Element resourcesElement = elem.element(RESOURCES_ELEMENT_NAME);
            if (resourcesElement != null) {
                List resourceElements = resourcesElement.elements("resource");
                for (Element resourceElement : resourceElements) {
                    ResourceDescription resourceDescription = new ResourceDescription();
                    resourceDescription.parse(resourceElement);
                    String[] scriptIds = resourceDescription.getScriptIds();
                    String scriptPackagePath = this.getPackage().getPath();
                    if (scriptIds != null) {
                        for (int i = 0; i < scriptIds.length; ++i) {
                            String webscriptId = scriptIds[i];
                            if (webscriptId.startsWith(scriptPackagePath)) continue;
                            scriptIds[i] = scriptPackagePath + "/" + webscriptId;
                        }
                    }
                    this.resourceDescriptionList.add(resourceDescription);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
        sb.append("<").append(ROOT_ELEMENT_NAME).append(" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://www.springsurf.org/schemas/DescriptionXMLSchema.xsd\"").append(">").append("\n");
        sb.append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        sb.append("    ").append("<resources>").append("\n");
        if (this.getResourceDescriptions() != null) {
            for (ResourceDescription rd : this.getResourceDescriptions()) {
                sb.append(rd.toString()).append("\n");
            }
        }
        sb.append("    ").append("</resources>").append("\n");
        sb.append("</").append(ROOT_ELEMENT_NAME).append(">");
        return sb.toString();
    }

    public static PackageDescriptionDocument newInstance() {
        PackageDescriptionDocument newPackageDescriptionDocument = new PackageDescriptionDocument("", "shortname", "description");
        return newPackageDescriptionDocument;
    }

    public PackageDescriptionDocument(String id, String shortName, String description) {
        super(id, shortName, description);
    }

    public PackageDescriptionDocument() {
    }
}

