/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.FormatWriter;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;

@ScriptClass(help="Render object to mimetype of web script template.  If object cannot be serialized to mimetype\nthen no output is written.\n\nUsage: formatwrite(object)", types={ScriptClassType.TemplateAPI})
public final class FormatWriterMethod
implements TemplateMethodModelEx {
    private FormatRegistry formatRegistry;
    private String mimetype;

    public FormatWriterMethod(FormatRegistry formatRegistry, String format) {
        this.formatRegistry = formatRegistry;
        this.mimetype = formatRegistry.getMimeType(null, format);
    }

    public Object exec(List args) throws TemplateModelException {
        String result = "";
        if (args.size() != 0) {
            FormatWriter<Object> writer;
            Object object = null;
            Object arg0 = args.get(0);
            if (arg0 instanceof BeanModel) {
                object = ((BeanModel)arg0).getWrappedObject();
            }
            if (object != null && (writer = this.formatRegistry.getWriter(object, this.mimetype)) != null) {
                writer.write(object, Environment.getCurrentEnvironment().getOut());
            }
        }
        return result;
    }
}

