/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.DescriptionExtension;
import org.springframework.extensions.webscripts.DescriptionImpl;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.PackageDescriptionDocument;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.PathImpl;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.SchemaDescriptionDocument;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.UriIndex;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public class DeclarativeRegistry
implements Registry,
ApplicationContextAware,
InitializingBean {
    public static final String WEBSCRIPT_DESC_XML = ".desc.xml";
    private static final Log logger = LogFactory.getLog(DeclarativeRegistry.class);
    private ApplicationContext applicationContext;
    private String defaultWebScript;
    private SearchPath searchPath;
    private Container container;
    private Map<String, WebScript> webscriptsById = new TreeMap<String, WebScript>();
    private Map<String, PathImpl> packageByPath = new TreeMap<String, PathImpl>();
    private Map<String, PathImpl> uriByPath = new TreeMap<String, PathImpl>();
    private Map<String, PathImpl> familyByPath = new TreeMap<String, PathImpl>();
    private Map<String, PathImpl> lifecycleByPath = new TreeMap<String, PathImpl>();
    private UriIndex uriIndex;
    private Map<String, String> failedWebScriptsByPath = new TreeMap<String, String>();
    private Map<String, PackageDescriptionDocument> packageDocumentByPath = new TreeMap<String, PackageDescriptionDocument>();
    private Map<String, SchemaDescriptionDocument> schemaDocumentById = new TreeMap<String, SchemaDescriptionDocument>();
    private Map<String, String> failedPackageDescriptionsByPath = new TreeMap<String, String>();
    private Map<String, String> failedSchemaDescriptionsByPath = new TreeMap<String, String>();
    private Map<String, Match> uriIndexCache = new ConcurrentHashMap<String, Match>(1024);
    private static final Match SENTINEL_MATCH = new Match(null, Collections.emptyMap(), null);
    private final ReadWriteLock indexResetLock = new ReentrantReadWriteLock();

    public void setDefaultWebScript(String defaultWebScript) {
        this.defaultWebScript = defaultWebScript;
    }

    public void setUriIndex(UriIndex uriIndex) {
        this.uriIndex = uriIndex;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.defaultWebScript == null || this.defaultWebScript.length() == 0 || !this.applicationContext.containsBean(this.defaultWebScript)) {
            throw new WebScriptException("Default Web Script implementation '" + (this.defaultWebScript == null ? "<undefined>" : this.defaultWebScript) + "' does not exist.");
        }
    }

    @Override
    public void reset() {
        this.initWebScripts();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered " + this.webscriptsById.size() + " Web Scripts (+" + this.failedWebScriptsByPath.size() + " failed), " + this.uriIndex.getSize() + " URLs"));
            logger.info((Object)("Registered " + this.packageDocumentByPath.size() + " Package Description Documents (+" + this.failedPackageDescriptionsByPath.size() + " failed) "));
            logger.info((Object)("Registered " + this.schemaDocumentById.size() + " Schema Description Documents (+" + this.failedSchemaDescriptionsByPath.size() + " failed) "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWebScripts() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising Web Scripts (Container: " + this.container.getName() + ", URI index: " + this.uriIndex.getClass().getName() + ")"));
        }
        this.indexResetLock.writeLock().lock();
        try {
            this.uriIndex.clear();
            this.uriIndexCache.clear();
            this.webscriptsById.clear();
            this.failedWebScriptsByPath.clear();
            this.packageByPath.clear();
            this.packageByPath.put("/", new PathImpl("/"));
            this.uriByPath.clear();
            this.uriByPath.put("/", new PathImpl("/"));
            this.familyByPath.clear();
            this.familyByPath.put("/", new PathImpl("/"));
            this.lifecycleByPath.clear();
            this.lifecycleByPath.put("/", new PathImpl("/"));
            this.failedPackageDescriptionsByPath.clear();
            this.failedSchemaDescriptionsByPath.clear();
            this.packageDocumentByPath.clear();
            this.schemaDocumentById.clear();
            for (Store store : this.searchPath.getStores()) {
                String[] serviceDescPaths;
                String[] schemaDescPaths;
                String[] packageDescPaths;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Locating package descriptions within " + store.getBasePath()));
                }
                try {
                    packageDescPaths = store.getDocumentPaths("/", true, "package-desc.xml");
                }
                catch (IOException e) {
                    throw new WebScriptException("Failed to search for package descriptions in store " + String.valueOf(store), e);
                }
                for (String packageDescPath : packageDescPaths) {
                    try {
                        PackageDescriptionDocument packageDesc = null;
                        InputStream packageDescIS = null;
                        try {
                            packageDescIS = store.getDocument(packageDescPath);
                            packageDesc = this.createPackageDescription(store, packageDescPath, packageDescIS);
                            String packageDescId = packageDesc.getId();
                            if (this.packageDocumentByPath.containsKey(packageDescId)) continue;
                            this.packageDocumentByPath.put(packageDescId, packageDesc);
                        }
                        catch (IOException e) {
                            throw new WebScriptException("Failed to read package description document " + store.getBasePath() + packageDescPath, e);
                        }
                        finally {
                            try {
                                if (packageDescIS != null) {
                                    packageDescIS.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (WebScriptException e) {
                        String path = store.getBasePath() + "/" + packageDescPath;
                        Object c = e;
                        Object cause = ((Throwable)c).getMessage();
                        while (((Throwable)c).getCause() != null && !((Throwable)c).getCause().equals(c)) {
                            c = ((Throwable)c).getCause();
                            cause = (String)cause + " ; " + ((Throwable)c).getMessage();
                        }
                        this.failedPackageDescriptionsByPath.put(path, (String)cause);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Locating schema descriptions within " + store.getBasePath()));
                }
                try {
                    schemaDescPaths = store.getDocumentPaths("/", true, "*.schema-desc.xml");
                }
                catch (IOException e) {
                    throw new WebScriptException("Failed to search for schema descriptions in store " + String.valueOf(store), e);
                }
                for (String schemaDescPath : schemaDescPaths) {
                    try {
                        SchemaDescriptionDocument schemaDesc = null;
                        InputStream schemaDescIS = null;
                        try {
                            schemaDescIS = store.getDocument(schemaDescPath);
                            schemaDesc = this.createSchemaDescription(store, schemaDescPath, schemaDescIS);
                            String schemaDescId = schemaDesc.getId();
                            if (this.schemaDocumentById.containsKey(schemaDescId)) continue;
                            this.schemaDocumentById.put(schemaDescId, schemaDesc);
                        }
                        catch (IOException e) {
                            throw new WebScriptException("Failed to read Web Script description document " + store.getBasePath() + schemaDescPath, e);
                        }
                        finally {
                            try {
                                if (schemaDescIS != null) {
                                    schemaDescIS.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (WebScriptException e) {
                        String path = store.getBasePath() + "/" + schemaDescPath;
                        Object c = e;
                        Object cause = ((Throwable)c).getMessage();
                        while (((Throwable)c).getCause() != null && !((Throwable)c).getCause().equals(c)) {
                            c = ((Throwable)c).getCause();
                            cause = (String)cause + " ; " + ((Throwable)c).getMessage();
                        }
                        this.failedSchemaDescriptionsByPath.put(path, (String)cause);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Locating Web Scripts within " + store.getBasePath()));
                }
                try {
                    serviceDescPaths = store.getDescriptionDocumentPaths();
                }
                catch (IOException e) {
                    throw new WebScriptException("Failed to search for web scripts in store " + String.valueOf(store), e);
                }
                for (String serviceDescPath : serviceDescPaths) {
                    try {
                        DescriptionImpl serviceDesc = null;
                        InputStream serviceDescIS = null;
                        try {
                            serviceDescIS = store.getDocument(serviceDescPath);
                            serviceDesc = this.createDescription(store, serviceDescPath, serviceDescIS);
                        }
                        catch (IOException e) {
                            throw new WebScriptException("Failed to read Web Script description document " + store.getBasePath() + serviceDescPath, e);
                        }
                        finally {
                            try {
                                if (serviceDescIS != null) {
                                    serviceDescIS.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        String id = serviceDesc.getId();
                        if (this.webscriptsById.containsKey(id)) {
                            if (!logger.isDebugEnabled()) continue;
                            WebScript existingService = this.webscriptsById.get(id);
                            Description existingDesc = existingService.getDescription();
                            String msg = "Web Script description document " + serviceDesc.getStorePath() + "/" + serviceDesc.getDescPath();
                            msg = msg + " overridden by " + existingDesc.getStorePath() + "/" + existingDesc.getDescPath();
                            logger.debug((Object)msg);
                            continue;
                        }
                        ApplicationContext applicationContext = this.getApplicationContext();
                        String kind = serviceDesc.getKind();
                        Object serviceImplName = null;
                        String descImplName = null;
                        if (kind == null) {
                            String beanName = "webscript." + id.replace('/', '.');
                            serviceImplName = applicationContext.containsBean(beanName) ? beanName : this.defaultWebScript;
                            descImplName = "webscriptdesc." + id.replace('/', '.');
                        } else {
                            if (!applicationContext.containsBean("webscript." + kind)) {
                                throw new WebScriptException("Web Script kind '" + kind + "' is unknown");
                            }
                            serviceImplName = "webscript." + kind;
                            descImplName = "webscriptdesc." + kind;
                        }
                        if (applicationContext.containsBean(descImplName) && applicationContext.isTypeMatch(descImplName, DescriptionExtension.class)) {
                            DescriptionExtension descriptionExtensions = (DescriptionExtension)applicationContext.getBean(descImplName);
                            serviceDescIS = null;
                            try {
                                serviceDescIS = store.getDocument(serviceDescPath);
                                Map<String, Serializable> extensions = descriptionExtensions.parseExtensions(serviceDescPath, serviceDescIS);
                                serviceDesc.setExtensions(extensions);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Extracted " + String.valueOf(extensions == null ? "0" : Integer.valueOf(extensions.size())) + " description extension(s) for Web Script " + id + " (" + String.valueOf(extensions) + ")"));
                                }
                            }
                            catch (IOException e) {
                                throw new WebScriptException("Failed to parse extensions from Web Script description document " + store.getBasePath() + serviceDescPath, e);
                            }
                            finally {
                                try {
                                    if (serviceDescIS != null) {
                                        serviceDescIS.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        WebScript serviceImpl = (WebScript)applicationContext.getBean((String)serviceImplName);
                        serviceImpl.init(this.container, serviceDesc);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found Web Script " + id + " (desc: " + serviceDescPath + ", impl: " + (String)serviceImplName + ", auth: " + String.valueOf((Object)serviceDesc.getRequiredAuthentication()) + ", trx: " + String.valueOf((Object)serviceDesc.getRequiredTransaction()) + ", format style: " + String.valueOf((Object)serviceDesc.getFormatStyle()) + ", default format: " + serviceDesc.getDefaultFormat() + ")"));
                        }
                        this.webscriptsById.put(id, serviceImpl);
                        for (String uriTemplate : serviceDesc.getURIs()) {
                            this.uriIndex.registerUri(serviceImpl, uriTemplate);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Registered Web Script URL '" + serviceImpl.getDescription().getMethod() + ":" + uriTemplate + "'"));
                        }
                        Path scriptPath = this.registerPackage(serviceImpl);
                        serviceDesc.setPackage(scriptPath);
                        this.registerURIs(serviceImpl);
                        this.registerFamily(serviceImpl);
                        this.registerLifecycle(serviceImpl);
                    }
                    catch (WebScriptException e) {
                        String path = store.getBasePath() + "/" + serviceDescPath;
                        Object c = e;
                        Object cause = ((Throwable)c).getMessage();
                        while (((Throwable)c).getCause() != null && !((Throwable)c).getCause().equals(c)) {
                            c = ((Throwable)c).getCause();
                            cause = (String)cause + " ; " + ((Throwable)c).getMessage();
                        }
                        this.failedWebScriptsByPath.put(path, (String)cause);
                    }
                }
            }
        }
        finally {
            this.indexResetLock.writeLock().unlock();
        }
        if (logger.isWarnEnabled()) {
            String msg;
            for (Map.Entry entry : this.failedWebScriptsByPath.entrySet()) {
                msg = "Unable to register script " + (String)entry.getKey() + " due to error: " + (String)entry.getValue();
                logger.warn((Object)msg);
            }
            for (Map.Entry entry : this.failedPackageDescriptionsByPath.entrySet()) {
                msg = "Unable to register package description document " + (String)entry.getKey() + " due to error: " + (String)entry.getValue();
                logger.warn((Object)msg);
            }
            for (Map.Entry entry : this.failedSchemaDescriptionsByPath.entrySet()) {
                msg = "Unable to register schema description document " + (String)entry.getKey() + " due to error: " + (String)entry.getValue();
                logger.warn((Object)msg);
            }
        }
    }

    private Path registerPackage(WebScript script) {
        String[] parts;
        Description desc = script.getDescription();
        PathImpl path = this.packageByPath.get("/");
        for (String part : parts = desc.getScriptPath().split("/")) {
            PathImpl subpath = this.packageByPath.get(PathImpl.concatPath(path.getPath(), part));
            if (subpath == null) {
                subpath = path.createChildPath(part);
                this.packageByPath.put(subpath.getPath(), subpath);
            }
            path = subpath;
        }
        path.addScript(script);
        return path;
    }

    private void registerFamily(WebScript script) {
        Description desc = script.getDescription();
        Set<String> familys = desc.getFamilys();
        for (String family : familys) {
            String[] parts;
            if (family == null || family.length() <= 0) continue;
            PathImpl path = this.familyByPath.get("/");
            for (String part : parts = family.split("/")) {
                PathImpl subpath = this.familyByPath.get(PathImpl.concatPath(path.getPath(), part));
                if (subpath == null) {
                    subpath = path.createChildPath(part);
                    this.familyByPath.put(subpath.getPath(), subpath);
                }
                path = subpath;
            }
            path.addScript(script);
        }
    }

    private void registerLifecycle(WebScript script) {
        Description desc = script.getDescription();
        Description.Lifecycle lifecycle = desc.getLifecycle();
        PathImpl path = this.lifecycleByPath.get("/");
        PathImpl subpath = this.lifecycleByPath.get(PathImpl.concatPath(path.getPath(), lifecycle.toString()));
        if (subpath == null) {
            subpath = path.createChildPath(lifecycle.toString());
            this.lifecycleByPath.put(subpath.getPath(), subpath);
        }
        subpath.addScript(script);
    }

    private void registerURIs(WebScript script) {
        Description desc = script.getDescription();
        for (String uri : desc.getURIs()) {
            String[] parts;
            PathImpl path = this.uriByPath.get("/");
            for (String part : parts = uri.split("/")) {
                PathImpl subpath;
                if (part.indexOf("?") != -1) {
                    part = part.substring(0, part.indexOf("?"));
                }
                if ((subpath = this.uriByPath.get(PathImpl.concatPath(path.getPath(), part))) == null) {
                    subpath = path.createChildPath(part);
                    this.uriByPath.put(subpath.getPath(), subpath);
                }
                path = subpath;
            }
            path.addScript(script);
        }
    }

    private PackageDescriptionDocument createPackageDescription(Store store, String packageDescPath, InputStream packageDoc) {
        try {
            PackageDescriptionDocument packageDesc = new PackageDescriptionDocument();
            int iPathIdx = packageDescPath.lastIndexOf(47);
            String packagePath = packageDescPath.substring(0, iPathIdx == -1 ? 0 : iPathIdx);
            packageDesc.setId("/" + packagePath);
            packageDesc.setDescPath(packageDescPath);
            packageDesc.setPackage(new PathImpl(packagePath));
            packageDesc.setStore(store);
            packageDesc.parseDocument(packageDoc);
            packageDesc.setId("/" + packagePath);
            return packageDesc;
        }
        catch (DocumentException e) {
            throw new WebScriptException("Failed to parse package description document " + packageDescPath, e);
        }
        catch (WebScriptException e) {
            throw new WebScriptException("Failed to parse package description document " + packageDescPath, (Throwable)((Object)e));
        }
    }

    private SchemaDescriptionDocument createSchemaDescription(Store store, String schemaDescPath, InputStream schemaDoc) {
        try {
            SchemaDescriptionDocument schemaDesc = new SchemaDescriptionDocument();
            int iPathIdx = schemaDescPath.lastIndexOf(47);
            String schemaName = schemaDescPath.substring(iPathIdx == -1 ? 0 : iPathIdx + 1);
            String id = schemaName.substring(0, schemaName.lastIndexOf("schema-desc.xml") - 1);
            schemaDesc.setId(id);
            schemaDesc.setDescPath(schemaDescPath);
            schemaDesc.setStore(store);
            schemaDesc.parseDocument(schemaDoc);
            schemaDesc.setId(id);
            return schemaDesc;
        }
        catch (DocumentException e) {
            throw new WebScriptException("Failed to parse schema description document " + schemaDescPath, e);
        }
        catch (WebScriptException e) {
            throw new WebScriptException("Failed to parse schema description document " + schemaDescPath, (Throwable)((Object)e));
        }
    }

    private DescriptionImpl createDescription(Store store, String serviceDescPath, InputStream serviceDoc) {
        try {
            TypeDescription registedType;
            int iPathIdx = serviceDescPath.lastIndexOf(47);
            String scriptPath = serviceDescPath.substring(0, iPathIdx == -1 ? 0 : iPathIdx);
            String id = serviceDescPath.substring(0, serviceDescPath.lastIndexOf(WEBSCRIPT_DESC_XML));
            int methodIdx = id.lastIndexOf(46);
            if (methodIdx == -1 || methodIdx == id.length() - 1) {
                throw new WebScriptException("Unable to establish HTTP Method from web script description: naming convention must be <name>.<method>.desc.xml");
            }
            String method = id.substring(methodIdx + 1).toUpperCase();
            DescriptionImpl serviceDesc = new DescriptionImpl();
            serviceDesc.setStore(store);
            serviceDesc.setScriptPath(scriptPath);
            serviceDesc.setDescPath(serviceDescPath);
            serviceDesc.setId(id);
            serviceDesc.setMethod(method);
            serviceDesc.parseDocument(serviceDoc);
            String defaultFormat = serviceDesc.getDefaultFormat();
            String defaultFormatMimetype = null;
            if (defaultFormat != null && (defaultFormatMimetype = this.container.getFormatRegistry().getMimeType(null, defaultFormat)) == null) {
                throw new WebScriptException("Default format '" + defaultFormat + "' is unknown");
            }
            if (serviceDesc.getRequestTypes() != null) {
                for (TypeDescription requestType : serviceDesc.getRequestTypes()) {
                    if (requestType.getId() == null) continue;
                    registedType = this.getSchemaTypeDescriptionById(requestType.getId());
                    if (registedType != null) {
                        requestType.setShortName(registedType.getShortName());
                        requestType.setDescription(registedType.getDescription());
                        requestType.setFormat(registedType.getFormat());
                        requestType.setDefinition(registedType.getDefinition());
                        requestType.setUrl(registedType.getUrl());
                        continue;
                    }
                    throw new WebScriptException("Invalid schema type reference " + requestType.getId());
                }
            }
            if (serviceDesc.getResponseTypes() != null) {
                for (TypeDescription responseType : serviceDesc.getResponseTypes()) {
                    if (responseType.getId() == null) continue;
                    registedType = this.getSchemaTypeDescriptionById(responseType.getId());
                    if (registedType != null) {
                        responseType.setShortName(registedType.getShortName());
                        responseType.setDescription(registedType.getDescription());
                        responseType.setFormat(registedType.getFormat());
                        responseType.setDefinition(registedType.getDefinition());
                        responseType.setUrl(registedType.getUrl());
                        continue;
                    }
                    throw new WebScriptException("Invalid schema type reference " + responseType.getId());
                }
            }
            return serviceDesc;
        }
        catch (DocumentException e) {
            throw new WebScriptException("Failed to parse web script description document " + serviceDescPath, e);
        }
        catch (WebScriptException e) {
            throw new WebScriptException("Failed to parse web script description document " + serviceDescPath, (Throwable)((Object)e));
        }
    }

    @Override
    public Path getPackage(String scriptPackage) {
        return this.packageByPath.get(scriptPackage);
    }

    @Override
    public Path getUri(String scriptUri) {
        return this.uriByPath.get(scriptUri);
    }

    @Override
    public Path getFamily(String scriptUri) {
        return this.familyByPath.get(scriptUri);
    }

    @Override
    public Collection<WebScript> getWebScripts() {
        return this.webscriptsById.values();
    }

    @Override
    public Map<String, String> getFailures() {
        return Collections.unmodifiableMap(this.failedWebScriptsByPath);
    }

    @Override
    public WebScript getWebScript(String id) {
        return this.webscriptsById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Match findWebScript(String method, String uri) {
        this.indexResetLock.readLock().lock();
        try {
            String key = new StringBuilder(uri.length() + 5).append(method).append('|').append(uri).toString();
            Match match = this.uriIndexCache.get(key);
            if (match == null) {
                boolean debug = logger.isDebugEnabled();
                long startTime = 0L;
                if (debug) {
                    startTime = System.nanoTime();
                }
                match = this.uriIndex.findWebScript(method, uri);
                if (debug) {
                    logger.debug((Object)("Web Script index lookup for uri " + uri + " took " + (float)(System.nanoTime() - startTime) / 1000000.0f + "ms"));
                }
                if (this.uriIndexCache.size() < 16384) {
                    if (match == null) {
                        match = SENTINEL_MATCH;
                    }
                    this.uriIndexCache.put(key, match);
                }
                if (debug) {
                    logger.debug((Object)("WebScript uriIndexCache size: " + this.uriIndexCache.size()));
                }
            }
            Match match2 = match != SENTINEL_MATCH ? match : null;
            return match2;
        }
        finally {
            this.indexResetLock.readLock().unlock();
        }
    }

    @Override
    public Path getLifecycle(String lifecyclePath) {
        return this.lifecycleByPath.get(lifecyclePath);
    }

    @Override
    public PackageDescriptionDocument getPackageDescriptionDocument(String scriptPackage) {
        return this.packageDocumentByPath.get(scriptPackage);
    }

    @Override
    public SchemaDescriptionDocument getSchemaDescriptionDocument(String schemaId) {
        return this.schemaDocumentById.get(schemaId);
    }

    @Override
    public Collection<PackageDescriptionDocument> getPackageDescriptionDocuments() {
        return this.packageDocumentByPath.values();
    }

    @Override
    public Collection<SchemaDescriptionDocument> getSchemaDescriptionDocuments() {
        return this.schemaDocumentById.values();
    }

    @Override
    public TypeDescription getSchemaTypeDescriptionById(String typeId) {
        for (SchemaDescriptionDocument doc : this.getSchemaDescriptionDocuments()) {
            if (!typeId.startsWith(doc.getId())) continue;
            for (TypeDescription type : doc.getTypeDescriptions()) {
                if (!typeId.equals(type.getId())) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getFailedPackageDescriptionsByPath() {
        return Collections.unmodifiableMap(this.failedPackageDescriptionsByPath);
    }

    @Override
    public Map<String, String> getFailedSchemaDescriptionsByPath() {
        return Collections.unmodifiableMap(this.failedSchemaDescriptionsByPath);
    }
}

