/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public abstract class ConfigModel {
    protected ConfigService configService;
    protected Map<String, ConfigElement> globalConfig;
    protected String scriptConfig;
    private static Log logger = LogFactory.getLog(ConfigModel.class);

    public ConfigModel(ConfigService configService, String scriptConfig) {
        this.configService = configService;
        this.scriptConfig = scriptConfig;
    }

    public Map<String, ConfigElement> getGlobal() {
        if (this.globalConfig == null) {
            if (this.configService != null) {
                this.globalConfig = this.configService.getGlobalConfig().getConfigElements();
            }
            if (this.globalConfig == null) {
                this.globalConfig = Collections.emptyMap();
            }
        }
        return this.globalConfig;
    }

    public Map<String, ConfigElement> getScoped() {
        return new ScopedConfigMap();
    }

    public abstract Object getScript();

    public class ScopedConfigMap
    extends HashMap {
        @Override
        public Object get(Object identifier) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting scoped config for '" + String.valueOf(identifier) + "'"));
            }
            Map map = null;
            if (ConfigModel.this.configService != null) {
                Config result = ConfigModel.this.configService.getConfig(identifier);
                map = result.getConfigElements();
            } else {
                map = Collections.emptyMap();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning config for '" + String.valueOf(identifier) + "': " + String.valueOf(map)));
            }
            return map;
        }
    }
}

