/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.ScriptParameterFactoryRegistry;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;

public abstract class AbstractRuntimeContainer
implements RuntimeContainer,
ApplicationListener,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(AbstractRuntimeContainer.class);
    protected ApplicationContext applicationContext = null;
    private boolean allowCallbacks = false;
    private String name = "<undefined>";
    private Registry registry;
    private FormatRegistry formatRegistry;
    private ScriptProcessorRegistry scriptProcessorRegistry;
    private TemplateProcessorRegistry templateProcessorRegistry;
    private ScriptParameterFactoryRegistry scriptParameterFactoryRegistry;
    private SearchPath searchPath;
    private ConfigService configService;
    private Map<String, Object> scriptObjects;
    private Map<String, Object> templateObjects;

    public void setName(String name) {
        this.name = name;
    }

    public void setFormatRegistry(FormatRegistry formatRegistry) {
        this.formatRegistry = formatRegistry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setScriptProcessorRegistry(ScriptProcessorRegistry scriptProcessorRegistry) {
        this.scriptProcessorRegistry = scriptProcessorRegistry;
    }

    public void setTemplateProcessorRegistry(TemplateProcessorRegistry templateProcessorRegistry) {
        this.templateProcessorRegistry = templateProcessorRegistry;
    }

    public void setScriptParameterFactoryRegistry(ScriptParameterFactoryRegistry scriptParameterFactoryRegistry) {
        this.scriptParameterFactoryRegistry = scriptParameterFactoryRegistry;
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this.scriptObjects = scriptObjects;
    }

    public void setTemplateObjects(Map<String, Object> templateObjects) {
        this.templateObjects = templateObjects;
    }

    public void setAllowCallbacks(boolean allowCallbacks) {
        this.allowCallbacks = allowCallbacks;
    }

    @Override
    public boolean allowCallbacks() {
        return this.allowCallbacks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Object> getScriptParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("server", this.getDescription());
        params.putAll(this.scriptObjects);
        return Collections.unmodifiableMap(params);
    }

    @Override
    public Map<String, Object> getTemplateParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(8, 1.0f);
        params.put("server", this.getDescription());
        params.put("date", new Date());
        params.putAll(this.templateObjects);
        return Collections.unmodifiableMap(params);
    }

    @Override
    public FormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public ScriptProcessorRegistry getScriptProcessorRegistry() {
        return this.scriptProcessorRegistry;
    }

    @Override
    public TemplateProcessorRegistry getTemplateProcessorRegistry() {
        return this.templateProcessorRegistry;
    }

    @Override
    public ScriptParameterFactoryRegistry getScriptParameterFactoryRegistry() {
        return this.scriptParameterFactoryRegistry;
    }

    @Override
    public SearchPath getSearchPath() {
        return this.searchPath;
    }

    @Override
    public void reset() {
        long startTime = System.nanoTime();
        try {
            this.scriptProcessorRegistry.reset();
            this.templateProcessorRegistry.reset();
            this.getRegistry().reset();
            this.configService.reset();
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Initialised " + this.getName() + " Web Script Container (in " + (float)(System.nanoTime() - startTime) / 1000000.0f + "ms)"));
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            this.reset();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Description.RequiredAuthentication getRequiredAuthentication() {
        return Description.RequiredAuthentication.none;
    }

    @Override
    public boolean authenticate(Authenticator auth, Description.RequiredAuthentication required) {
        if (required != null && !required.equals((Object)Description.RequiredAuthentication.none)) {
            logger.error((Object)("Unexpected - required authentication = " + String.valueOf((Object)required)));
            return false;
        }
        return true;
    }
}

