/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.dom4j.Element;
import org.springframework.extensions.webscripts.BaseDescription;
import org.springframework.extensions.webscripts.WebScriptException;

public abstract class AbstractBaseDescription
implements BaseDescription {
    private String id;
    private String shortName;
    private String description;

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public boolean validateRootElement(Element rootElement, String name) {
        if (rootElement == null) {
            throw new WebScriptException("Invalid XML root element.");
        }
        if (!rootElement.getName().equals(name)) {
            throw new WebScriptException("Expected <" + name + "> root element - found <" + rootElement.getName() + ">");
        }
        return true;
    }

    public void parse(Element rootElement) {
        Element descElement;
        Element nameElement;
        Element idElement = rootElement.element("id");
        if (idElement != null) {
            this.setId(idElement.getText());
        }
        if ((nameElement = rootElement.element("shortname")) != null) {
            this.setShortName(nameElement.getText());
        }
        if ((descElement = rootElement.element("description")) != null) {
            this.setDescription(descElement.getText());
        }
    }

    protected boolean compareField(String text1, String text2) {
        if (text1 == null) {
            return text2 == null;
        }
        if (text2 == null) {
            return false;
        }
        return text2.equals(text1);
    }

    public AbstractBaseDescription(String id, String shortName, String description) {
        this.id = id;
        this.shortName = shortName;
        this.description = description;
    }

    public AbstractBaseDescription() {
    }
}

