/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.extensibility.CloseModelElement;
import org.springframework.extensions.surf.extensibility.ContentModelElement;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;
import org.springframework.extensions.surf.extensibility.DeferredContentTargetModelElement;
import org.springframework.extensions.surf.extensibility.ExtensibilityDirectiveData;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.ExtensibilityModelElement;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.OpenModelElement;
import org.springframework.extensions.surf.extensibility.impl.CloseModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.DefaultContentModelElement;
import org.springframework.extensions.surf.extensibility.impl.DiscardUnboundContentModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityDebugData;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.extensibility.impl.OpenModelElementImpl;
import org.springframework.extensions.surf.extensibility.impl.UnboundContentModelElementImpl;

public class ExtensibilityModelImpl
implements ExtensibilityModel {
    private static final Log logger = LogFactory.getLog(ExtensibilityModelImpl.class);
    private ExtensibilityModel parentModel = null;
    private HandlesExtensibility handler = null;
    private ExtensibilityDebugData debugData = new ExtensibilityDebugData();
    private ExtensibilityDebugData childDebugData = null;
    private ArrayList<ExtensibilityModelElement> modelContent = new ArrayList();
    private boolean modelStarted = false;
    private boolean extensionProcessing = false;
    private ModelWriter modelWriter = new ModelWriter();
    private Stack<ExtensibilityDirectiveData> directiveStack = new Stack();
    private List<ExtensibilityModelElement> additionalContent = null;

    @Override
    public ExtensibilityModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public ExtensibilityDebugData getDebugData() {
        return this.debugData;
    }

    @Override
    public ExtensibilityDebugData getChildDebugData() {
        return this.childDebugData;
    }

    @Override
    public void setChildDebugData(ExtensibilityDebugData childData) {
        this.childDebugData = childData;
    }

    public ExtensibilityModelImpl(ExtensibilityModel parentModel, HandlesExtensibility handler) {
        this.parentModel = parentModel;
        this.handler = handler;
    }

    @Override
    public boolean isModelStarted() {
        return this.modelStarted;
    }

    @Override
    public ModelWriter getWriter() {
        return this.modelWriter;
    }

    @Override
    public void switchToExtensionProcessing() {
        this.extensionProcessing = true;
        this.addDiscardContent();
    }

    @Override
    public boolean isExtensionProcessing() {
        return this.extensionProcessing;
    }

    @Override
    public void insertDeferredContentTarget(int index, OpenModelElement open, DeferredContentTargetModelElement target, CloseModelElement close) {
        if (this.modelContent.size() < index) {
            index = this.modelContent.size();
        }
        this.modelContent.add(index, close);
        this.modelContent.add(index, target);
        this.modelContent.add(index, open);
    }

    private void pushDirective(ExtensibilityDirectiveData directiveData) {
        this.pushDirective(directiveData, this.modelContent);
    }

    private void pushDirective(ExtensibilityDirectiveData directiveData, List<ExtensibilityModelElement> model) {
        this.directiveStack.push(directiveData);
        model.add(directiveData.createOpen());
        ContentModelElement contentElement = directiveData.createContentModelElement();
        model.add(contentElement);
        this.debugData.addData(contentElement.getId(), contentElement.getDirectiveName(), this.handler.getFileBeingProcessed());
        this.modelWriter.setCurrentBufferElement(contentElement.getNextContentBufferElement());
    }

    private ExtensibilityDirectiveData popDirective() {
        return this.popDirective(this.modelContent);
    }

    private ExtensibilityDirectiveData popDirective(List<ExtensibilityModelElement> model) {
        ExtensibilityDirectiveData currentDirective = this.directiveStack.pop();
        model.add(currentDirective.createClose());
        if (this.directiveStack.isEmpty()) {
            if (this.extensionProcessing) {
                this.addDiscardContent();
            } else {
                this.addUnboundContent();
            }
        } else {
            ExtensibilityDirectiveData lastDirective = this.directiveStack.peek();
            ContentModelElement contentElement = lastDirective.createContentModelElement();
            model.add(contentElement);
            this.modelWriter.setCurrentBufferElement(contentElement.getNextContentBufferElement());
        }
        return currentDirective;
    }

    @Override
    public void addUnboundContent() {
        this.modelStarted = true;
        UnboundContentModelElementImpl unboundContent = new UnboundContentModelElementImpl();
        this.modelContent.add(unboundContent);
        this.modelWriter.setCurrentBufferElement(unboundContent.getNextContentBufferElement());
    }

    @Override
    public void addDiscardContent() {
        this.modelStarted = true;
        DiscardUnboundContentModelElementImpl discardContent = new DiscardUnboundContentModelElementImpl();
        this.modelContent.add(discardContent);
        this.modelWriter.setCurrentBufferElement(discardContent.getNextContentBufferElement());
    }

    @Override
    public DeferredContentTargetModelElement getDeferredContent(String directiveId, String directiveName) {
        return this.getDeferredContent(directiveId, directiveName, this);
    }

    private DeferredContentTargetModelElement getDeferredContent(String directiveId, String directiveName, ExtensibilityModel modelScope) {
        DeferredContentTargetModelElement deferredContent = null;
        if (modelScope != null && modelScope instanceof ExtensibilityModelImpl) {
            RangeData targetRange = ((ExtensibilityModelImpl)modelScope).findTargetRange(directiveId, directiveName);
            if (targetRange != null) {
                ExtensibilityModelElement o = ((ExtensibilityModelImpl)modelScope).modelContent.get(targetRange.getStartingIndex() + 1);
                if (o instanceof DeferredContentTargetModelElement) {
                    deferredContent = (DeferredContentTargetModelElement)o;
                }
            } else {
                deferredContent = this.getDeferredContent(directiveId, directiveName, modelScope.getParentModel());
            }
        }
        return deferredContent;
    }

    @Override
    public void flushModel(Writer out) {
        Writer targetWriter = out;
        if (this.parentModel != null) {
            targetWriter = this.parentModel.getWriter();
        }
        for (ExtensibilityModelElement element : this.modelContent) {
            if (!(element instanceof ContentModelElement)) continue;
            ContentModelElement cme = (ContentModelElement)element;
            try {
                targetWriter.write(cme.flushContent());
            }
            catch (IOException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error((Object)("The following exception occurred flushing the model for ContentModelElement: " + String.valueOf(cme)), (Throwable)e);
            }
        }
        this.directiveStack.clear();
        this.modelContent.clear();
        this.modelStarted = false;
    }

    @Override
    public void merge(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.modelStarted = true;
        if (this.isExtensionProcessing()) {
            List<ExtensibilityModelElement> additionalElements = this.getAdditionalContentElements();
            if (additionalElements != null) {
                this.pushDirective(directiveData, additionalElements);
                directiveData.render(this.modelWriter);
                this.popDirective(additionalElements);
            } else {
                logger.error((Object)"A merge request was made as a root extension request. This is not allowed.");
            }
        } else {
            this.pushDirective(directiveData);
            directiveData.render(this.modelWriter);
            this.popDirective();
        }
    }

    @Override
    public List<ExtensibilityModelElement> getAdditionalContentElements() {
        List<ExtensibilityModelElement> additionalElements = this.additionalContent;
        if (additionalElements == null && this.parentModel != null) {
            additionalElements = this.parentModel.getAdditionalContentElements();
        }
        return additionalElements;
    }

    private List<ExtensibilityModelElement> generateAdditionalContent(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        this.additionalContent = new ArrayList<ExtensibilityModelElement>();
        this.pushDirective(directiveData, this.additionalContent);
        directiveData.render(this.modelWriter);
        this.popDirective(this.additionalContent);
        return this.additionalContent;
    }

    @Override
    public void before(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                List<DeferredContentSourceModelElement> deferredContentSourceElements = this.enterDeferredContentEditMode(targetRange, "before");
                List<ExtensibilityModelElement> additionalElements = this.generateAdditionalContent(directiveData);
                this.modelContent.addAll(targetRange.getStartingIndex(), additionalElements);
                this.exitDeferredContentEditMode(deferredContentSourceElements);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not locate target directive when processing 'before' action for directive: " + String.valueOf(directiveData)));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'before' action was attempted to used when defining the base model by directive:" + String.valueOf(directiveData)));
        }
    }

    @Override
    public void after(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                List<DeferredContentSourceModelElement> deferredContentSourceElements = this.enterDeferredContentEditMode(targetRange, "after");
                List<ExtensibilityModelElement> additionalElements = this.generateAdditionalContent(directiveData);
                this.modelContent.addAll(targetRange.getEndingIndex() + 1, additionalElements);
                this.exitDeferredContentEditMode(deferredContentSourceElements);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not locate target directive when processing 'after' action for directive: " + String.valueOf(directiveData)));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'after' action was attempted to used when defining the base model by directive:" + String.valueOf(directiveData)));
        }
    }

    @Override
    public void remove(ExtensibilityDirectiveData directiveData) {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find target " + directiveData.getTarget() + " to remove when processing directive: " + String.valueOf(directiveData)));
                }
            } else {
                List<DeferredContentSourceModelElement> deferredContentSourceElements = this.enterDeferredContentEditMode(targetRange, "remove");
                targetRange.getTargetRange().clear();
                this.exitDeferredContentEditMode(deferredContentSourceElements);
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'remove' action was attempted to used when defining the base model by directive:" + String.valueOf(directiveData)));
        }
    }

    @Override
    public void replace(ExtensibilityDirectiveData directiveData) throws TemplateException, IOException {
        if (this.extensionProcessing) {
            RangeData targetRange = this.findTargetRange(directiveData.getTarget(), directiveData.getDirectiveName());
            if (targetRange != null) {
                List<DeferredContentSourceModelElement> deferredContentSourceElements = this.enterDeferredContentEditMode(targetRange, "replace");
                targetRange.getTargetRange().clear();
                this.additionalContent = new ArrayList<ExtensibilityModelElement>();
                this.pushDirective(directiveData, this.additionalContent);
                directiveData.render(this.modelWriter);
                this.popDirective(this.additionalContent);
                this.exitDeferredContentEditMode(deferredContentSourceElements);
                this.modelContent.addAll(targetRange.getStartingIndex(), this.additionalContent);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find target " + directiveData.getTarget() + " to replace when processing directive: " + String.valueOf(directiveData)));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The 'replace' action was attempted to used when defining the base model by directive:" + String.valueOf(directiveData)));
        }
    }

    public List<DeferredContentSourceModelElement> enterDeferredContentEditMode(RangeData targetRange, String action) {
        ArrayList<DeferredContentSourceModelElement> deferredSourceElements = new ArrayList<DeferredContentSourceModelElement>();
        for (ExtensibilityModelElement element : targetRange.getTargetRange()) {
            if (!(element instanceof DeferredContentSourceModelElement)) continue;
            ((DeferredContentSourceModelElement)element).enterEditMode(action);
            deferredSourceElements.add((DeferredContentSourceModelElement)element);
        }
        return deferredSourceElements;
    }

    public void exitDeferredContentEditMode(List<DeferredContentSourceModelElement> deferredSourceElements) {
        for (DeferredContentSourceModelElement element : deferredSourceElements) {
            element.exitEditMode();
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringBuilder indent = new StringBuilder();
        for (ExtensibilityModelElement element : this.modelContent) {
            if (element.getType().equals("CLOSE")) {
                indent.delete(indent.length() - 4, indent.length());
            }
            out.append(String.valueOf(indent) + "<" + element.getType() + " id=\"" + element.getId() + "\">\n");
            if (!element.getType().equals("OPEN")) continue;
            indent.append("    ");
        }
        return out.toString();
    }

    @Override
    public ContentModelElement findContentModelElement(String id) {
        ContentModelElement target = null;
        DefaultContentModelElement matcher = new DefaultContentModelElement(id, null);
        int index = this.modelContent.indexOf(matcher);
        if (index != -1) {
            target = (ContentModelElement)this.modelContent.get(index);
        }
        return target;
    }

    @Override
    public boolean clearRelocatedContent(String id, String directiveName) {
        boolean success = false;
        RangeData targetRange = this.findTargetRange(id, directiveName);
        if (targetRange != null) {
            targetRange.getTargetRange().clear();
        }
        return success;
    }

    private RangeData findTargetRange(String id, String directiveName) {
        RangeData results = null;
        List<ExtensibilityModelElement> targetRange = null;
        OpenModelElementImpl targetOpen = new OpenModelElementImpl(id, directiveName);
        int openIndex = this.modelContent.indexOf(targetOpen);
        if (openIndex == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Could not find extensibiliy OPEN model element with the id: " + id));
            }
        } else {
            CloseModelElementImpl targetClose = new CloseModelElementImpl(id, null);
            int closeIndex = this.modelContent.indexOf(targetClose);
            if (closeIndex == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find extensibiliy CLOSE model element with the id: " + id));
                }
            } else if (closeIndex > openIndex) {
                targetRange = this.modelContent.subList(openIndex, closeIndex + 1);
                results = new RangeData(openIndex, closeIndex, targetRange);
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("An unexpected error occurred, the index of the CLOSE element is less that that of the associated OPEN element for target id: " + id));
            }
        }
        return results;
    }

    private class RangeData {
        private int startingIndex = -1;
        private int endingIndex = -1;
        private List<ExtensibilityModelElement> targetRange = null;

        public RangeData(int startingIndex, int endingIndex, List<ExtensibilityModelElement> targetRange) {
            this.startingIndex = startingIndex;
            this.endingIndex = endingIndex;
            this.targetRange = targetRange;
        }

        public int getStartingIndex() {
            return this.startingIndex;
        }

        public int getEndingIndex() {
            return this.endingIndex;
        }

        public List<ExtensibilityModelElement> getTargetRange() {
            return this.targetRange;
        }
    }
}

