/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.extensions.surf.extensibility.XMLHelper;

public class Customization {
    public static final String TARGET_PACKAGE = "targetPackageRoot";
    public static final String SOURCE_PACKAGE = "sourcePackageRoot";
    public static final String COMMON_WEBSCRIPTS = "alwaysApply";
    public static final String WEBSCRIPT_NAME = "webscript";
    public static final String DEPENDENCIES = "dependencies";
    public static final String CSS = "css";
    public static final String CSS_MEDIA = "media";
    public static final String DEFAULT_CSS_MEDIA = "screen";
    public static final String JS = "js";
    public static final String EVALUATOR = "evaluator";
    public static final String EVALUATOR_PROPS = "evaluatorProperties";
    public static final String EVALUATOR_PROP = "evaluatorProperty";
    public static final String EVALUATOR_PROP_NAME = "name";
    public static final String EVALUATOR_PROP_VALUE = "value";
    private String targetPackageName = null;
    private String sourcePackageName = null;
    private List<String> commonWebScripts;
    private Map<String, List<String>> cssDependencies;
    private List<String> jsDependencies;
    private String evaluator = null;
    private Map<String, String> evaluatorProperties = new HashMap<String, String>();

    public Customization(Element sourceElement) {
        this.applyConfiguration(sourceElement);
    }

    public void applyConfiguration(Element customizationEl) {
        this.targetPackageName = XMLHelper.getStringData(TARGET_PACKAGE, customizationEl, true);
        this.sourcePackageName = XMLHelper.getStringData(SOURCE_PACKAGE, customizationEl, true);
        this.commonWebScripts = this.getJavaScriptDependencies(COMMON_WEBSCRIPTS, WEBSCRIPT_NAME, customizationEl);
        this.evaluatorProperties = XMLHelper.getProperties(EVALUATOR_PROPS, customizationEl);
        this.cssDependencies = this.getCssDependencies(DEPENDENCIES, CSS, customizationEl);
        this.jsDependencies = this.getJavaScriptDependencies(DEPENDENCIES, JS, customizationEl);
    }

    private List<String> getJavaScriptDependencies(String elementName, String dependencyElementName, Element sourceElement) {
        ArrayList<String> dependencies = new ArrayList<String>();
        Element el = sourceElement.element(elementName);
        if (el != null) {
            List elementList = el.elements(dependencyElementName);
            for (Element element : elementList) {
                dependencies.add(element.getTextTrim());
            }
        }
        return dependencies;
    }

    private Map<String, List<String>> getCssDependencies(String elementName, String dependencyElementName, Element sourceElement) {
        HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
        Element el = sourceElement.element(elementName);
        if (el != null) {
            List elementList = el.elements(dependencyElementName);
            for (Element element : elementList) {
                ArrayList<String> mediaSpecificDependencies;
                String media = element.attributeValue(CSS_MEDIA);
                if (media == null) {
                    media = DEFAULT_CSS_MEDIA;
                }
                if ((mediaSpecificDependencies = (ArrayList<String>)dependencies.get(media)) == null) {
                    mediaSpecificDependencies = new ArrayList<String>();
                    dependencies.put(media, mediaSpecificDependencies);
                }
                mediaSpecificDependencies.add(element.getTextTrim());
            }
        }
        return dependencies;
    }

    public String getTargetPackageName() {
        return this.targetPackageName;
    }

    public String getSourcePackageName() {
        return this.sourcePackageName;
    }

    public List<String> getCommonWebScripts() {
        if (this.commonWebScripts == null) {
            this.commonWebScripts = new ArrayList<String>();
        }
        return this.commonWebScripts;
    }

    public Map<String, List<String>> getCssDependencies() {
        if (this.cssDependencies == null) {
            this.cssDependencies = new HashMap<String, List<String>>();
        }
        return this.cssDependencies;
    }

    public List<String> getJsDependencies() {
        if (this.jsDependencies == null) {
            this.jsDependencies = new ArrayList<String>();
        }
        return this.jsDependencies;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public Map<String, String> getEvaluatorProperties() {
        return this.evaluatorProperties;
    }
}

