/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.RemoteConfigProperties;
import org.springframework.extensions.config.element.ConfigElementAdapter;
import org.springframework.util.StringUtils;

public class RemoteConfigElement
extends ConfigElementAdapter
implements RemoteConfigProperties {
    private static final Log logger = LogFactory.getLog(RemoteConfigElement.class);
    private static final String REMOTE_SSL_CONFIG = "ssl-config";
    private static final String REMOTE_ENDPOINT = "endpoint";
    private static final String REMOTE_AUTHENTICATOR = "authenticator";
    private static final String REMOTE_CONNECTOR = "connector";
    private static final String CONFIG_ELEMENT_ID = "remote";
    protected SSLConfigDescriptor sslConfigDescriptor;
    protected HashMap<String, ConnectorDescriptor> connectors = new HashMap(10);
    protected HashMap<String, AuthenticatorDescriptor> authenticators = new HashMap(10);
    protected HashMap<String, EndpointDescriptor> endpoints = new HashMap(10);
    protected String defaultEndpointId;
    protected String defaultCredentialVaultProviderId;

    public RemoteConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ConfigElement combine(ConfigElement element) {
        RemoteConfigElement configElement = (RemoteConfigElement)element;
        RemoteConfigElement combinedElement = new RemoteConfigElement();
        combinedElement.connectors.putAll(this.connectors);
        combinedElement.authenticators.putAll(this.authenticators);
        combinedElement.endpoints.putAll(this.endpoints);
        combinedElement.connectors.putAll(configElement.connectors);
        combinedElement.authenticators.putAll(configElement.authenticators);
        combinedElement.endpoints.putAll(configElement.endpoints);
        combinedElement.defaultEndpointId = this.defaultEndpointId;
        if (configElement.defaultEndpointId != null) {
            combinedElement.defaultEndpointId = configElement.defaultEndpointId;
        }
        combinedElement.defaultCredentialVaultProviderId = this.defaultCredentialVaultProviderId;
        if (configElement.defaultCredentialVaultProviderId != null) {
            combinedElement.defaultCredentialVaultProviderId = configElement.defaultCredentialVaultProviderId;
        }
        combinedElement.sslConfigDescriptor = this.sslConfigDescriptor;
        if (configElement.sslConfigDescriptor != null) {
            combinedElement.sslConfigDescriptor = configElement.sslConfigDescriptor;
        }
        return combinedElement;
    }

    @Override
    public String[] getConnectorIds() {
        return this.connectors.keySet().toArray(new String[this.connectors.size()]);
    }

    @Override
    public ConnectorDescriptor getConnectorDescriptor(String id) {
        return this.connectors.get(id);
    }

    @Override
    public String[] getAuthenticatorIds() {
        return this.authenticators.keySet().toArray(new String[this.authenticators.size()]);
    }

    @Override
    public AuthenticatorDescriptor getAuthenticatorDescriptor(String id) {
        return this.authenticators.get(id);
    }

    @Override
    public String[] getEndpointIds() {
        return this.endpoints.keySet().toArray(new String[this.endpoints.size()]);
    }

    @Override
    public EndpointDescriptor getEndpointDescriptor(String id) {
        return this.endpoints.get(id);
    }

    @Override
    public String getDefaultEndpointId() {
        if (this.defaultEndpointId == null) {
            return "alfresco";
        }
        return this.defaultEndpointId;
    }

    @Override
    public String getDefaultCredentialVaultProviderId() {
        if (this.defaultCredentialVaultProviderId == null) {
            return "credential.vault.provider";
        }
        return this.defaultCredentialVaultProviderId;
    }

    @Override
    public SSLConfigDescriptor getSSLConfigDescriptor() {
        return this.sslConfigDescriptor;
    }

    protected static RemoteConfigElement newInstance(Element elem) {
        Element remoteSSLConfig;
        String _defaultCredentialVaultProviderId;
        RemoteConfigElement configElement = new RemoteConfigElement();
        List connectors = elem.elements(REMOTE_CONNECTOR);
        for (int i = 0; i < connectors.size(); ++i) {
            Element el = (Element)connectors.get(i);
            ConnectorDescriptor descriptor = new ConnectorDescriptor(el);
            configElement.connectors.put(descriptor.getId(), descriptor);
        }
        List authenticators = elem.elements(REMOTE_AUTHENTICATOR);
        for (int i = 0; i < authenticators.size(); ++i) {
            Element el = (Element)authenticators.get(i);
            AuthenticatorDescriptor descriptor = new AuthenticatorDescriptor(el);
            configElement.authenticators.put(descriptor.getId(), descriptor);
        }
        List endpoints = elem.elements(REMOTE_ENDPOINT);
        for (int i = 0; i < endpoints.size(); ++i) {
            Element el = (Element)endpoints.get(i);
            EndpointDescriptor descriptor = new EndpointDescriptor(el);
            configElement.endpoints.put(descriptor.getId(), descriptor);
        }
        String _defaultEndpointId = elem.elementTextTrim("default-endpoint-id");
        if (_defaultEndpointId != null && _defaultEndpointId.length() > 0) {
            configElement.defaultEndpointId = _defaultEndpointId;
        }
        if ((_defaultCredentialVaultProviderId = elem.elementTextTrim("default-credential-vault-provider-id")) != null && _defaultCredentialVaultProviderId.length() > 0) {
            configElement.defaultCredentialVaultProviderId = _defaultCredentialVaultProviderId;
        }
        if ((remoteSSLConfig = elem.element(REMOTE_SSL_CONFIG)) != null) {
            configElement.sslConfigDescriptor = new SSLConfigDescriptor(remoteSSLConfig);
        }
        return configElement;
    }

    public static class SSLConfigDescriptor
    extends Descriptor {
        private static final String KEYSTORE_PATH = "keystore-path";
        private static final String KEYSTORE_TYPE = "keystore-type";
        private static final String KEYSTORE_PASSWORD = "keystore-password";
        private static final String TRUSTSTORE_PATH = "truststore-path";
        private static final String TRUSTSTORE_TYPE = "truststore-type";
        private static final String TRUSTSTORE_PASSWORD = "truststore-password";
        private static final String VERIFY_HOSTNAME = "verify-hostname";
        private Registry<ConnectionSocketFactory> socketFactoryRegistry;

        SSLConfigDescriptor(Element el) {
            super(el);
            KeyStore keyStore = this.loadKeyStore(KEYSTORE_PATH, KEYSTORE_TYPE, KEYSTORE_PASSWORD);
            KeyStore trustStore = this.loadKeyStore(TRUSTSTORE_PATH, TRUSTSTORE_TYPE, TRUSTSTORE_PASSWORD);
            if (keyStore == null && trustStore == null) {
                logger.warn((Object)"Custom SSL socket factory was not configured, as there was no Keystore or Truststore.");
                return;
            }
            try {
                boolean verifyHostname;
                String verifyHostStr = this.getStringProperty(VERIFY_HOSTNAME);
                boolean bl = verifyHostname = StringUtils.isEmpty((Object)verifyHostStr) ? true : Boolean.valueOf(verifyHostStr);
                if (verifyHostname) {
                    logger.info((Object)"Creating custom SSL socket factory with hostname verification enabled.");
                } else {
                    logger.warn((Object)"Creating custom SSL socket factory with hostname verification disabled.");
                }
                HostnameVerifier hostnameVerifier = verifyHostname ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE;
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (keyStore != null) {
                    sslContextBuilder.loadKeyMaterial(keyStore, this.getPassword(KEYSTORE_PASSWORD));
                }
                if (trustStore != null) {
                    sslContextBuilder.loadTrustMaterial(trustStore, null);
                }
                SSLContext sslContext = sslContextBuilder.useProtocol("TLS").build();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
                this.socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)socketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }

        private KeyStore loadKeyStore(String pathElmName, String typeElmName, String passwordElmName) {
            KeyStore keyStore;
            String path = this.getStringProperty(pathElmName);
            if (StringUtils.isEmpty((Object)path)) {
                String storeKind = TRUSTSTORE_PATH.equals(pathElmName) ? "Truststore" : "Keystore";
                logger.warn((Object)("No SSL " + storeKind + " was configured."));
                return null;
            }
            char[] password = this.getPassword(passwordElmName);
            if (password == null) {
                logger.warn((Object)"No SSL key store password was provided. Attempt to load a key store without a password.");
            }
            FileInputStream keyStoreIn = new FileInputStream(new File(path));
            try {
                KeyStore keyStore2 = KeyStore.getInstance(this.getStringProperty(typeElmName));
                keyStore2.load(keyStoreIn, password);
                keyStore = keyStore2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)keyStoreIn).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception error) {
                    logger.error((Object)error);
                    return null;
                }
            }
            ((InputStream)keyStoreIn).close();
            return keyStore;
        }

        private char[] getPassword(String passwordElmName) {
            String passwordStr = this.getStringProperty(passwordElmName);
            return StringUtils.isEmpty((Object)passwordStr) ? null : passwordStr.toCharArray();
        }

        public Registry<ConnectionSocketFactory> getSocketFactoryRegistry() {
            return this.socketFactoryRegistry;
        }
    }

    public static class ConnectorDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String AUTHENTICATOR_ID = "authenticator-id";
        private static final String UNAUTHENTICATED_MODE = "unauthenticated-mode";
        private static final String RECONNECT_TIMEOUT = "reconnect-timeout";

        ConnectorDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getAuthenticatorId() {
            return this.getStringProperty(AUTHENTICATOR_ID);
        }

        public String getUnauthenticatedMode() {
            return this.getStringProperty(UNAUTHENTICATED_MODE);
        }

        public String getReconnectTimeout() {
            return this.getStringProperty(RECONNECT_TIMEOUT);
        }
    }

    public static class AuthenticatorDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";

        AuthenticatorDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }
    }

    public static class EndpointDescriptor
    extends Descriptor {
        private static final String PASSWORD = "password";
        private static final String USERNAME = "username";
        private static final String IDENTITY = "identity";
        private static final String ENDPOINT_URL = "endpoint-url";
        private static final String AUTH_ID = "auth-id";
        private static final String CONNECTOR_ID = "connector-id";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String UNSECURE = "unsecure";
        private static final String BASIC_AUTH = "basic-auth";
        private static final String EXTERNAL_AUTH = "external-auth";
        private static final String PARENT_ID = "parent-id";

        EndpointDescriptor(Element el) {
            super(el);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getConnectorId() {
            return this.getStringProperty(CONNECTOR_ID);
        }

        public String getAuthId() {
            return this.getStringProperty(AUTH_ID);
        }

        public String getEndpointUrl() {
            return this.getStringProperty(ENDPOINT_URL);
        }

        public IdentityType getIdentity() {
            IdentityType identityType = IdentityType.NONE;
            String identity = this.getStringProperty(IDENTITY);
            if (identity != null) {
                identityType = IdentityType.valueOf(identity.toUpperCase());
            }
            return identityType;
        }

        public String getUsername() {
            return this.getStringProperty(USERNAME);
        }

        public String getPassword() {
            return this.getStringProperty(PASSWORD);
        }

        public boolean getUnsecure() {
            return Boolean.parseBoolean(this.getStringProperty(UNSECURE));
        }

        public boolean getBasicAuth() {
            return Boolean.parseBoolean(this.getStringProperty(BASIC_AUTH));
        }

        public boolean getExternalAuth() {
            return Boolean.parseBoolean(this.getStringProperty(EXTERNAL_AUTH));
        }

        public String getParentId() {
            return this.getStringProperty(PARENT_ID);
        }
    }

    public static enum IdentityType {
        DECLARED,
        USER,
        NONE;

    }

    public static class Descriptor
    implements Serializable {
        private static final String ID = "id";
        protected HashMap<String, Object> map = new HashMap();

        Descriptor(Element el) {
            List elements = el.elements();
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                this.put(element);
            }
        }

        public void put(Element el) {
            String key = el.getName();
            String value = el.getTextTrim();
            if (value != null) {
                this.map.put(key, value);
            }
        }

        public Object get(String key) {
            return this.map.get(key);
        }

        public String getId() {
            return (String)this.get(ID);
        }

        public Object getProperty(String key) {
            return this.get(key);
        }

        public String getStringProperty(String key) {
            return (String)this.get(key);
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

