/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.documents;

import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.Test;
import org.springframework.extensions.webscripts.AbstractRuntimeContainer;
import org.springframework.extensions.webscripts.AbstractWebScriptServerTest;
import org.springframework.extensions.webscripts.ArgumentTypeDescription;
import org.springframework.extensions.webscripts.ClassPathStore;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.PackageDescriptionDocument;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.ResourceDescription;
import org.springframework.extensions.webscripts.SchemaDescriptionDocument;
import org.springframework.extensions.webscripts.TypeDescription;
import org.springframework.extensions.webscripts.WebScript;

public class WebscriptDocumentTest
extends AbstractWebScriptServerTest {
    @Override
    public void setUp() throws ServletException {
        super.setUp();
        this.getClassPathStore().init();
    }

    @Override
    public ArrayList<String> getConfigLocations() {
        ArrayList<String> list = super.getConfigLocations();
        list.add("classpath:org/springframework/extensions/webscripts/stores/spring-webscripts-stores-context.xml");
        return list;
    }

    public ClassPathStore getClassPathStore() {
        return (ClassPathStore)this.getTestServer().getApplicationContext().getBean("webscripts.store.test");
    }

    public AbstractRuntimeContainer getWebscriptContainer() {
        return (AbstractRuntimeContainer)this.getTestServer().getApplicationContext().getBean("webscripts.container");
    }

    public Registry getWebscriptRegistry() {
        return this.getWebscriptContainer().getRegistry();
    }

    @Test
    public void testPackageDescriptionDocumentCount() throws Exception {
        Collection docs = this.getWebscriptRegistry().getPackageDescriptionDocuments();
        int numberOfPackageDescipiontDocs = docs.size();
        WebscriptDocumentTest.assertEquals((int)1, (int)numberOfPackageDescipiontDocs);
    }

    @Test
    public void testGetPackageDescriptionDocumentByPath() throws Exception {
        PackageDescriptionDocument doc = this.getWebscriptRegistry().getPackageDescriptionDocument("/documents/samples");
        WebscriptDocumentTest.assertNotNull((Object)doc);
    }

    @Test
    public void testPackageDescriptionDocumentNameDescription() throws Exception {
        PackageDescriptionDocument doc = this.getWebscriptRegistry().getPackageDescriptionDocument("/documents/samples");
        WebscriptDocumentTest.assertNotNull((Object)doc);
        String shortName = doc.getShortName();
        WebscriptDocumentTest.assertEquals((String)"Alfresco samples", (String)shortName);
        String description = doc.getDescription();
        WebscriptDocumentTest.assertEquals((String)"Alfresco sample webscripts", (String)description);
    }

    @Test
    public void testPackageDescriptionDocumentResources() throws Exception {
        PackageDescriptionDocument doc = this.getWebscriptRegistry().getPackageDescriptionDocument("/documents/samples");
        WebscriptDocumentTest.assertNotNull((Object)doc);
        ResourceDescription[] resources = doc.getResourceDescriptions();
        WebscriptDocumentTest.assertNotNull((Object)resources);
        WebscriptDocumentTest.assertEquals((int)2, (int)resources.length);
        String shortName = resources[0].getShortName();
        WebscriptDocumentTest.assertEquals((String)"Alfresco sample1", (String)shortName);
        String description = resources[0].getDescription();
        WebscriptDocumentTest.assertEquals((String)"Alfresco sample1 webscript", (String)description);
        String[] scriptIds = resources[0].getScriptIds();
        WebscriptDocumentTest.assertEquals((int)4, (int)scriptIds.length);
        WebscriptDocumentTest.assertEquals((String)"documents/samples/sample1.get", (String)scriptIds[0]);
    }

    @Test
    public void testSchemaDescriptionDocumentCount() throws Exception {
        Collection docs = this.getWebscriptRegistry().getSchemaDescriptionDocuments();
        int numOfDocs = docs.size();
        WebscriptDocumentTest.assertEquals((int)1, (int)numOfDocs);
    }

    @Test
    public void testGetSchemaDescriptionDocumentById() throws Exception {
        SchemaDescriptionDocument doc = this.getWebscriptRegistry().getSchemaDescriptionDocument("samples.sample1");
        WebscriptDocumentTest.assertNotNull((Object)doc);
    }

    @Test
    public void testSchemaDescriptionDocumentNameDescription() throws Exception {
        SchemaDescriptionDocument doc = this.getWebscriptRegistry().getSchemaDescriptionDocument("samples.sample1");
        WebscriptDocumentTest.assertNotNull((Object)doc);
        String shortName = doc.getShortName();
        WebscriptDocumentTest.assertEquals((String)"Schema for sample1", (String)shortName);
        String description = doc.getDescription();
        WebscriptDocumentTest.assertEquals((String)"Schema for sample1 in package samples", (String)description);
    }

    @Test
    public void testSchemaDescriptionDocumentTypes() throws Exception {
        SchemaDescriptionDocument doc = this.getWebscriptRegistry().getSchemaDescriptionDocument("samples.sample1");
        WebscriptDocumentTest.assertNotNull((Object)doc);
        TypeDescription[] types = doc.getTypeDescriptions();
        WebscriptDocumentTest.assertNotNull((Object)types);
        WebscriptDocumentTest.assertEquals((int)2, (int)types.length);
        TypeDescription type = types[0];
        WebscriptDocumentTest.assertEquals((String)"samples.sample1.status", (String)type.getId());
        WebscriptDocumentTest.assertEquals((String)"json", (String)type.getFormat());
        WebscriptDocumentTest.assertEquals((String)"status", (String)type.getShortName());
        WebscriptDocumentTest.assertEquals((String)"Sample Status", (String)type.getDescription());
        WebscriptDocumentTest.assertNotNull((Object)type.getDefinition());
        WebscriptDocumentTest.assertTrue((type.getDefinition().trim().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWebscriptDescriptionDocument() throws Exception {
        WebScript ws = this.getWebscriptRegistry().getWebScript("documents/samples/sample1.get");
        WebscriptDocumentTest.assertNotNull((Object)ws);
        Description wsDesc = ws.getDescription();
        WebscriptDocumentTest.assertNotNull((Object)wsDesc);
        ArgumentTypeDescription[] args = wsDesc.getArguments();
        WebscriptDocumentTest.assertNotNull((Object)args);
        WebscriptDocumentTest.assertEquals((int)3, (int)args.length);
        ArgumentTypeDescription arg = args[0];
        WebscriptDocumentTest.assertEquals((String)"arg1", (String)arg.getShortName());
        WebscriptDocumentTest.assertEquals((String)"argument 1", (String)arg.getDescription());
        WebscriptDocumentTest.assertEquals((String)"arg1", (String)arg.getDefaultValue());
        WebscriptDocumentTest.assertFalse((boolean)arg.isRequired());
        TypeDescription[] requestTypes = wsDesc.getRequestTypes();
        WebscriptDocumentTest.assertNotNull((Object)requestTypes);
        WebscriptDocumentTest.assertEquals((int)1, (int)requestTypes.length);
        TypeDescription requestType = requestTypes[0];
        WebscriptDocumentTest.assertEquals((String)"json", (String)requestType.format);
        WebscriptDocumentTest.assertNotNull((Object)requestType.getDefinition());
        WebscriptDocumentTest.assertTrue((requestType.getDefinition().trim().length() > 0 ? 1 : 0) != 0);
        TypeDescription[] responseTypes = wsDesc.getResponseTypes();
        WebscriptDocumentTest.assertNotNull((Object)responseTypes);
        WebscriptDocumentTest.assertEquals((int)2, (int)responseTypes.length);
        TypeDescription responseType = responseTypes[0];
        WebscriptDocumentTest.assertNotNull((Object)responseType);
        WebscriptDocumentTest.assertEquals((String)"json", (String)responseType.getFormat());
        WebscriptDocumentTest.assertEquals((String)"samples.sample1.status", (String)responseType.getId());
    }

    @Test
    public void testGetTypeDescriptionById() throws Exception {
        TypeDescription type = this.getWebscriptRegistry().getSchemaTypeDescriptionById("samples.sample1.status");
        WebscriptDocumentTest.assertNotNull((Object)type);
    }

    @Test
    public void testBadSchemaDescriptionDocuments() throws Exception {
        Map schemas = this.getWebscriptRegistry().getFailedSchemaDescriptionsByPath();
        WebscriptDocumentTest.assertNotNull((Object)schemas);
        WebscriptDocumentTest.assertEquals((int)1, (int)schemas.size());
    }

    @Test
    public void testBadPackageDescriptionDocuments() throws Exception {
        Map packages = this.getWebscriptRegistry().getFailedPackageDescriptionsByPath();
        WebscriptDocumentTest.assertNotNull((Object)packages);
        WebscriptDocumentTest.assertEquals((int)1, (int)packages.size());
    }

    @Test
    public void testBadWebscriptDescriptionDocuments() throws Exception {
        Map ws = this.getWebscriptRegistry().getFailures();
        WebscriptDocumentTest.assertNotNull((Object)ws);
        WebscriptDocumentTest.assertEquals((int)3, (int)ws.size());
    }
}

