/**
 * Copyright (C) 2005-2015 Alfresco Software Limited.
 *
 * This file is part of the Spring Surf Extension project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.extensions.config;

import org.springframework.extensions.config.RemoteConfigElement.AuthenticatorDescriptor;
import org.springframework.extensions.config.RemoteConfigElement.ConnectorDescriptor;
import org.springframework.extensions.config.RemoteConfigElement.EndpointDescriptor;
import org.springframework.extensions.config.RemoteConfigElement.SSLConfigDescriptor;

/**
 * @author muzquiano
 */
public interface RemoteConfigProperties
{
    // remote connectors
    public String[] getConnectorIds();
    public ConnectorDescriptor getConnectorDescriptor(String id);

    // remote authenticators
    public String[] getAuthenticatorIds();
    public AuthenticatorDescriptor getAuthenticatorDescriptor(String id);

    // remote endpoints
    public String[] getEndpointIds();
    public EndpointDescriptor getEndpointDescriptor(String id);
        
    // defaults
    public String getDefaultEndpointId();
    public String getDefaultCredentialVaultProviderId();

    public SSLConfigDescriptor getSSLConfigDescriptor();
}
