/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class ServiceInstall
extends DeclarativeWebScript {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        if (!(req instanceof WebScriptServletRequest)) {
            throw new WebScriptException("Web Script install only supported via HTTP Servlet");
        }
        HttpServletRequest servletReq = ((WebScriptServletRequest)req).getHttpServletRequest();
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        ArrayList<InstalledFile> installedFiles = new ArrayList<InstalledFile>();
        model.put("installedFiles", installedFiles);
        try {
            Object content = req.parseContent();
            if (content == null || !(content instanceof FormData)) {
                throw new WebScriptException(400, "Web Script install request is not multipart/form-data");
            }
            FormData formData = (FormData)content;
            FormData.FormField file = null;
            for (FormData.FormField field : formData.getFields()) {
                if (!field.getIsFile()) continue;
                if (file != null) {
                    throw new WebScriptException(400, "Web Script install request expects only one file upload");
                }
                file = field;
            }
            if (file == null) {
                throw new WebScriptException(400, "Web Script install request is missing file upload");
            }
            Document document = null;
            try (InputStream fileIS = file.getContent().getInputStream();){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileIS));
                SAXReader reader = SAXReader.createDefault();
                document = reader.read((Reader)bufferedReader);
            }
            Element rootElement = document.getRootElement();
            XPath xpath = rootElement.createXPath("//ws:webscript");
            HashMap<String, String> uris = new HashMap<String, String>();
            uris.put("ws", "http://www.alfresco.org/webscript/1.0");
            xpath.setNamespaceURIs(uris);
            List nodes = xpath.selectNodes((Object)rootElement);
            if (nodes.size() == 0) {
                throw new WebScriptException(400, "Cannot locate Web Script in uploaded file");
            }
            Element webscriptElem = (Element)nodes.get(0);
            String scriptId = webscriptElem.attributeValue("scriptid");
            if (scriptId == null || scriptId.length() == 0) {
                throw new WebScriptException(400, "Expected scriptid value on webscript element");
            }
            Iterator iter = webscriptElem.elementIterator();
            while (iter.hasNext()) {
                Element fileElem = (Element)iter.next();
                String webscriptStore = fileElem.attributeValue("store");
                if (webscriptStore == null || webscriptStore.length() == 0) {
                    throw new WebScriptException(400, "Expected store value on webscript element");
                }
                String webscriptPath = fileElem.attributeValue("path");
                if (webscriptPath == null || webscriptPath.length() == 0) {
                    throw new WebScriptException(400, "Expected file value on webscript element");
                }
                String webscriptContent = fileElem.getText();
                this.installFile(webscriptStore, webscriptPath, webscriptContent);
                InstalledFile installedFile = new InstalledFile();
                installedFile.store = webscriptStore;
                installedFile.path = webscriptPath;
                installedFiles.add(installedFile);
            }
            this.getContainer().reset();
            Registry registry = this.getContainer().getRegistry();
            WebScript webscript = registry.getWebScript(scriptId);
            if (webscript == null) {
                throw new WebScriptException(500, "Failed to install Web Script " + scriptId);
            }
            model.put("installedScript", webscript.getDescription());
        }
        catch (DocumentException e) {
            throw new WebScriptException(500, e.getMessage());
        }
        catch (IOException e) {
            throw new WebScriptException(500, e.getMessage());
        }
        return model;
    }

    private void installFile(String storePath, String file, String content) {
        Store store = this.getContainer().getSearchPath().getStore(storePath);
        if (store == null) {
            throw new WebScriptException(500, "Store path " + storePath + " refers to a store that does not exist");
        }
        try {
            if (store.hasDocument(file)) {
                throw new WebScriptException(500, "Web Script file " + file + " already exists in store " + storePath);
            }
            store.createDocument(file, content);
        }
        catch (IOException e) {
            throw new WebScriptException(500, "Failed to install Web Script file " + file + " into store" + storePath);
        }
    }

    public static class InstalledFile {
        private String store;
        private String path;

        public String getStore() {
            return this.store;
        }

        public String getPath() {
            return this.path;
        }
    }
}

