/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.webscripts.ScriptModelObject;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptHelper
implements Serializable {
    public static ScriptableMap toScriptableMap(RequestContext context, ModelObject[] modelObjects) {
        ScriptableLinkedHashMap map = new ScriptableLinkedHashMap(modelObjects.length);
        for (int i = 0; i < modelObjects.length; ++i) {
            ScriptModelObject scriptModelObject = ScriptHelper.toScriptModelObject(context, modelObjects[i]);
            String id = modelObjects[i].getId();
            map.put((Object)id, (Object)scriptModelObject);
        }
        return map;
    }

    public static ScriptableMap toScriptableMap(RequestContext context, Map<String, ModelObject> objects) {
        ScriptableLinkedHashMap map = new ScriptableLinkedHashMap(objects.size());
        for (String id : objects.keySet()) {
            ModelObject modelObject = objects.get(id);
            ScriptModelObject scriptModelObject = ScriptHelper.toScriptModelObject(context, modelObject);
            map.put((Object)id, (Object)scriptModelObject);
        }
        return map;
    }

    public static ScriptableMap toScriptableMap(Map<String, Serializable> map) {
        return new ScriptableLinkedHashMap(map);
    }

    public static Scriptable toScriptableArray(Scriptable scope, String[] elements) {
        Object[] array = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            array[i] = elements[i];
        }
        return Context.getCurrentContext().newArray(scope, array);
    }

    public static ScriptModelObject toScriptModelObject(RequestContext context, ModelObject modelObject) {
        if (modelObject != null) {
            return new ScriptModelObject(context, modelObject);
        }
        return null;
    }

    public static Object[] toScriptModelObjectArray(RequestContext context, ModelObject[] modelObjects) {
        Object[] array = new Object[]{};
        if (modelObjects != null) {
            array = new Object[modelObjects.length];
            for (int i = 0; i < modelObjects.length; ++i) {
                array[i] = ScriptHelper.toScriptModelObject(context, modelObjects[i]);
            }
        }
        return array;
    }

    public static Object[] toScriptModelObjectArray(RequestContext context, Map<String, ModelObject> objects) {
        Object[] array = objects.values().toArray(new Object[objects.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i] = ScriptHelper.toScriptModelObject(context, (ModelObject)array[i]);
        }
        return array;
    }

    public static ScriptModelObject getObject(RequestContext context, String objectTypeId, String objectId) {
        ScriptModelObject scriptModelObject = null;
        ModelObject modelObject = context.getObjectService().getObject(objectTypeId, objectId);
        if (modelObject != null) {
            scriptModelObject = new ScriptModelObject(context, modelObject);
        }
        return scriptModelObject;
    }
}

