/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.AlfrescoConnector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;

public class RequestCachingConnector
extends AlfrescoConnector {
    private static Log logger = LogFactory.getLog(RequestCachingConnector.class);
    private static final String REQUEST_CACHE_KEY = "_alf_request_cache";

    public RequestCachingConnector(RemoteConfigElement.ConnectorDescriptor descriptor, String endpoint) {
        super(descriptor, endpoint);
    }

    public Response call(String uri, ConnectorContext context) {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        if (rc != null && context == null || context.getMethod() == HttpMethod.GET) {
            Map<String, Response> cache;
            Response response;
            boolean debug = logger.isDebugEnabled();
            if (debug) {
                logger.debug((Object)("Intercepted call to URI: " + uri));
            }
            if ((response = (cache = RequestCachingConnector.getResponseCache(rc)).get(uri)) == null) {
                if (debug) {
                    logger.debug((Object)" uncached - calling super...");
                }
                if ((response = super.call(uri, context)).getStatus().getCode() == 200) {
                    cache.put(uri, response);
                }
            } else if (debug) {
                logger.debug((Object)" cached - returning cached response...");
            }
            return response;
        }
        return super.call(uri, context);
    }

    private static Map<String, Response> getResponseCache(RequestContext rc) {
        HashMap cache = (HashMap)rc.getValue(REQUEST_CACHE_KEY);
        if (cache == null) {
            cache = new HashMap(16);
            rc.setValue(REQUEST_CACHE_KEY, cache);
        }
        return cache;
    }
}

