/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GetCacheReport
extends DeclarativeWebScript {
    private static String INFO = "Since last refresh, cache entries have {0} by {1} items and the total size has {2} by {3} bytes.";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        long lastCount;
        HashMap<String, Object> model = new HashMap<String, Object>();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((WebScriptServletRequest)req).getHttpServletRequest().getSession().getServletContext());
        Map beans = context.getBeansOfType(CacheReporter.class);
        boolean clear = Boolean.parseBoolean(req.getParameter("clear"));
        long totalSize = 0L;
        long totalCount = 0L;
        LinkedHashMap modelBeans = new LinkedHashMap();
        for (String bean : beans.keySet()) {
            CacheReporter reporter = (CacheReporter)beans.get(bean);
            if (clear) {
                reporter.clearCaches();
            }
            ArrayList modelBeanReporter = new ArrayList();
            List<CacheReport> reports = reporter.report();
            for (CacheReport report : reports) {
                HashMap<String, Object> modelBeanReporterReport = new HashMap<String, Object>();
                modelBeanReporterReport.put("name", report.getCacheName());
                int entryCount = report.getEntryCount();
                modelBeanReporterReport.put("count", entryCount);
                totalCount += (long)entryCount;
                long entrySize = report.getValueSizeEstimate();
                modelBeanReporterReport.put("size", entrySize);
                totalSize += entrySize;
                modelBeanReporter.add(modelBeanReporterReport);
            }
            modelBeans.put(bean, modelBeanReporter);
        }
        model.put("totalcount", totalCount);
        model.put("totalsize", totalSize);
        model.put("reports", modelBeans);
        String strLastSize = req.getParameter("ls");
        long lastSize = strLastSize != null && strLastSize.length() != 0 ? Long.parseLong(strLastSize) : -1L;
        String strLastCount = req.getParameter("lc");
        long l = lastCount = strLastCount != null && strLastCount.length() != 0 ? Long.parseLong(strLastCount) : -1L;
        if (lastSize != -1L && lastCount != -1L) {
            String info = MessageFormat.format(INFO, totalCount >= lastCount ? "increased" : "decreased", Math.abs(totalCount - lastCount), totalSize >= lastSize ? "increased" : "decreased", Math.abs(totalSize - lastSize));
            model.put("info", info);
        }
        return model;
    }
}

