/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.types.AdvancedComponent;
import org.springframework.extensions.surf.types.ComponentImpl;
import org.springframework.extensions.surf.types.SubComponent;

public class AdvancedComponentImpl
extends ComponentImpl
implements AdvancedComponent {
    private static final long serialVersionUID = 2691649813539118537L;
    private static final Log logger = LogFactory.getLog(AdvancedComponentImpl.class);
    public static final String SUB_COMPONENT_ELEMENT_CONVERSION_ID = "default";
    private boolean advancedConfig = false;
    private List<SubComponent> subComponents = null;
    private ReadWriteLock subComponentsLock = new ReentrantReadWriteLock();

    @Override
    public boolean isAdvancedConfig() {
        return this.advancedConfig;
    }

    public AdvancedComponentImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        Element renderableElements = document.getRootElement().element("sub-components");
        this.advancedConfig = renderableElements != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubComponent> getSubComponents() {
        this.subComponentsLock.readLock().lock();
        try {
            if (this.subComponents == null) {
                this.subComponentsLock.readLock().unlock();
                this.subComponentsLock.writeLock().lock();
                try {
                    if (this.subComponents == null) {
                        if (this.advancedConfig) {
                            this.applyConfig(this.getDocument().getRootElement());
                        } else {
                            this.subComponents = new ArrayList<SubComponent>();
                            String id = this.getId();
                            if (id == null) {
                                id = RenderUtil.generateComponentId(this.getScope(), this.getRegionId(), this.getSourceId());
                            }
                            String uri = this.getURI();
                            String componentTypeId = this.getComponentTypeId();
                            String processorId = this.getProcessorId();
                            SubComponent componentElement = new SubComponent(SUB_COMPONENT_ELEMENT_CONVERSION_ID, id);
                            componentElement.setUri(uri);
                            componentElement.setComponentTypeId(componentTypeId);
                            componentElement.setProcessorId(processorId);
                            componentElement.setAllProperties(this.getModelProperties(), this.getCustomProperties());
                            this.subComponents.add(componentElement);
                        }
                    }
                }
                finally {
                    this.subComponentsLock.readLock().lock();
                    this.subComponentsLock.writeLock().unlock();
                }
            }
            List<SubComponent> list = this.subComponents;
            return list;
        }
        finally {
            this.subComponentsLock.readLock().unlock();
        }
    }

    @Override
    public void setSubComponents(List<SubComponent> subComponents) {
        this.subComponentsLock.writeLock().lock();
        try {
            this.subComponents = subComponents;
        }
        finally {
            this.subComponentsLock.writeLock().unlock();
        }
    }

    @Override
    public void applyConfig(Element componentEl) {
        ArrayList<SubComponent> componentElements = new ArrayList<SubComponent>();
        Element subComponentsEl = componentEl.element("sub-components");
        if (subComponentsEl != null) {
            this.advancedConfig = true;
            List subComponentList = subComponentsEl.elements("sub-component");
            for (Element subComponentEl : subComponentList) {
                String subComponentId = subComponentEl.attributeValue("id");
                if (subComponentId != null) {
                    SubComponent componentElement = new SubComponent(subComponentId, this.getId());
                    componentElement.applyConfiguration(subComponentEl);
                    componentElements.add(componentElement);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("<component> '" + this.getId() + "' is configured with a <sub-component> that does not have an 'id' attribute"));
            }
        }
        this.setSubComponents(componentElements);
    }
}

