/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.exception.ResourceLoaderException;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceProvider;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.util.XMLUtil;

public class ModelObjectResourceProvider
implements ResourceProvider {
    protected ModelObject object;
    protected Map<String, Resource> resources;

    public ModelObjectResourceProvider(ModelObject object) {
        this.object = object;
    }

    @Override
    public Resource getResource(String name) {
        return this.getResourcesMap().get(name);
    }

    @Override
    public Resource[] getResources() {
        Map<String, Resource> map = this.getResourcesMap();
        return map.values().toArray(new Resource[map.size()]);
    }

    @Override
    public Resource addResource(String name, String resourceId) {
        String[] ids = FrameworkBean.getResourceService().getResourceDescriptorIds(resourceId);
        return this.addResource(name, ids[0], ids[1], ids[2]);
    }

    @Override
    public synchronized Resource addResource(String name, String protocolId, String endpointId, String objectId) {
        Resource resource = this.getResourcesMap().get(name);
        if (resource == null) {
            Element rootElement = ModelObjectResourceProvider.getResourcesElement(this.object);
            Element resourceElement = rootElement.addElement("resource");
            resourceElement.addAttribute("name", name);
            resourceElement.addAttribute("protocol", protocolId);
            resourceElement.addAttribute("endpoint", endpointId);
            if (objectId != null && !"".equals(objectId)) {
                XMLUtil.setValue(resourceElement, objectId);
            }
            if ((resource = this.loadResource(protocolId, endpointId, objectId)) != null) {
                this.resources.put(name, resource);
            }
        }
        return resource;
    }

    @Override
    public void updateResource(String name, Resource resource) {
        Element element = ModelObjectResourceProvider.getResourceElement(this.object, name);
        if (element != null) {
            String objectId;
            String endpoint;
            List attributes = element.attributes();
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                element.remove(attribute);
            }
            element.addAttribute("name", name);
            String protocol = resource.getProtocolId();
            if (protocol != null && !"".equals(protocol)) {
                element.addAttribute("protocol", protocol);
            }
            if ((endpoint = resource.getEndpointId()) != null && !"".equals(endpoint)) {
                element.addAttribute("endpoint", endpoint);
            }
            if ((objectId = resource.getObjectId()) != null && !"".equals(objectId)) {
                XMLUtil.setValue(element, objectId);
            }
        }
    }

    @Override
    public void removeResource(String name) {
        Element element = ModelObjectResourceProvider.getResourceElement(this.object, name);
        if (element != null) {
            Element rootElement = ModelObjectResourceProvider.getResourcesElement(this.object);
            rootElement.remove(element);
            this.resources.remove(name);
        }
    }

    @Override
    public synchronized Map<String, Resource> getResourcesMap() {
        if (this.resources == null) {
            this.resources = new HashMap<String, Resource>(8, 1.0f);
            Element rootElement = ModelObjectResourceProvider.getResourcesElement(this.object);
            List elements = rootElement.elements("resource");
            for (int i = 0; i < elements.size(); ++i) {
                Element el = (Element)elements.get(i);
                String name = el.attributeValue("name");
                String protocolId = el.attributeValue("protocol");
                String endpointId = el.attributeValue("endpoint");
                String objectId = XMLUtil.getValue(el);
                Resource resource = this.loadResource(protocolId, endpointId, objectId);
                this.resources.put(name, resource);
            }
        }
        return this.resources;
    }

    protected static Element getResourcesElement(ModelObject object) {
        Element result = null;
        List elements = object.getDocument().getRootElement().elements("resources");
        result = elements.size() > 0 ? (Element)elements.get(0) : object.getDocument().getRootElement().addElement("resources");
        return result;
    }

    protected static Element getResourceElement(ModelObject object, String name) {
        Element result = null;
        Element rootElement = ModelObjectResourceProvider.getResourcesElement(object);
        List elements = rootElement.elements("resource");
        for (int i = 0; i < elements.size(); ++i) {
            Element el = (Element)elements.get(i);
            String _name = el.attributeValue("name");
            if (!_name.equals(name)) continue;
            result = el;
            break;
        }
        return result;
    }

    private Resource loadResource(String protocolId, String endpointId, String objectId) {
        Resource resource = null;
        ResourceService resourceService = FrameworkUtil.getServiceRegistry().getResourceService();
        try {
            resource = resourceService.getResource(protocolId, endpointId, objectId);
        }
        catch (ResourceLoaderException rle) {
            rle.printStackTrace();
        }
        return resource;
    }
}

