/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.AbstractObjectPersister;
import org.springframework.extensions.surf.persister.CachedPersister;

public class MultiObjectPersister
extends AbstractObjectPersister
implements CachedPersister {
    private static final Log logger = LogFactory.getLog(MultiObjectPersister.class);
    private List<ModelObjectPersister> persisters;
    private ModelObjectPersister defaultPersister;

    public void setPersisters(List<ModelObjectPersister> persisters) {
        this.persisters = persisters;
    }

    public List<ModelObjectPersister> getPersisters() {
        return this.persisters;
    }

    public void setDefaultPersister(ModelObjectPersister defaultPersister) {
        this.defaultPersister = defaultPersister;
    }

    @Override
    public ModelObject getObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean debug = logger.isDebugEnabled();
        ModelObject modelObject = null;
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            try {
                if (debug) {
                    logger.debug((Object)("getObject attempting to load '" + objectId + "' of type '" + objectTypeId + "' from persister: " + persisterId));
                }
                modelObject = persister.getObject(context, objectTypeId, objectId);
            }
            catch (ModelObjectPersisterException mope) {
                throw new ModelObjectPersisterException("Error loading object id: " + objectId + " from persister id: " + persisterId, mope);
            }
            if (modelObject == null) continue;
            if (!debug) break;
            logger.debug((Object)("getObject loaded '" + objectId + "' from persister: " + persisterId));
            break;
        }
        if (modelObject == null && debug) {
            logger.debug((Object)"getObject() unable to get object from any persisters");
        }
        return modelObject;
    }

    @Override
    public boolean saveObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        ModelObjectPersister targetPersister;
        boolean saved = false;
        if (object != null && (targetPersister = this.resolveTargetPersister(object)) != null) {
            saved = targetPersister.saveObject(context, object);
        }
        return saved;
    }

    private ModelObjectPersister resolveTargetPersister(ModelObject object) throws ModelObjectPersisterException {
        ModelObjectPersister targetPersister = this.defaultPersister;
        String targetPersisterId = object.getPersisterId();
        if (targetPersisterId != null && !targetPersisterId.equals(this.getId())) {
            targetPersister = this.getPersisterService().getPersisterIdToPersisterMap().get(targetPersisterId);
            if (targetPersister.hasReadOnlyStore()) {
                targetPersister = this.defaultPersister;
            }
            if (targetPersister == null) {
                throw new ModelObjectPersisterException("The target persister: \"" + targetPersisterId + "\" configured for the object: \"" + String.valueOf(object) + "\" does not exist");
            }
        }
        return targetPersister;
    }

    @Override
    public boolean saveObjects(ModelPersistenceContext context, List<ModelObject> objects) throws ModelObjectPersisterException {
        boolean saved = true;
        LinkedHashMap<ModelObjectPersister, LinkedList<ModelObject>> saveMap = new LinkedHashMap<ModelObjectPersister, LinkedList<ModelObject>>();
        for (ModelObject object : objects) {
            ModelObjectPersister persister = this.resolveTargetPersister(object);
            LinkedList<ModelObject> toAppend = (LinkedList<ModelObject>)saveMap.get(persister);
            if (toAppend == null) {
                toAppend = new LinkedList<ModelObject>();
                saveMap.put(persister, toAppend);
            }
            toAppend.add(object);
        }
        for (ModelObjectPersister persister : saveMap.keySet()) {
            boolean bl = saved = persister.saveObjects(context, (List)saveMap.get(persister)) && saved;
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("saveObjects save to persister '" + persister.getId() + "' returned: " + saved));
        }
        return saved;
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.removeObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean removed = false;
        for (ModelObjectPersister persister : this.persisters) {
            String persisterId = persister.getId();
            if (persister.hasObject(context, objectTypeId, objectId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removeObject attempting to remove '" + objectId + "' of type '" + objectTypeId + "' from persister: " + persisterId));
                }
                removed = persister.removeObject(context, objectTypeId, objectId);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("removeObject removed from persister '" + persisterId + "' returned: " + removed));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeObject cleaning up cache for persister '" + persisterId));
            }
            persister.removeObject(context, objectTypeId, objectId);
        }
        return removed;
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.hasObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        boolean hasObject = false;
        for (ModelObjectPersister persister : this.persisters) {
            if (!persister.hasObject(context, objectTypeId, objectId)) continue;
            hasObject = true;
            break;
        }
        return hasObject;
    }

    @Override
    public ModelObject newObject(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        ModelObject obj = null;
        ModelObjectPersister targetPersister = this.getPersisterService().getTypeToPersisterMap().get(objectTypeId);
        if (targetPersister == null) {
            throw new ModelObjectPersisterException("The persister configured for object type: \"" + objectTypeId + "\" does not exist");
        }
        if (targetPersister == this) {
            if (this.defaultPersister == null) {
                throw new ModelObjectPersisterException("Unable to create new object - no default persister configured");
            }
            targetPersister = this.defaultPersister;
        }
        obj = this.defaultPersister.newObject(context, objectTypeId, objectId);
        return obj;
    }

    @Override
    public Map<String, ModelObject> getAllObjects(ModelPersistenceContext context, String objectTypeId) throws ModelObjectPersisterException {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(512, 1.0f);
        for (ModelObjectPersister persister : this.persisters) {
            Map<String, ModelObject> map = persister.getAllObjects(context, objectTypeId);
            objects.putAll(map);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAllObjects returned set of size: " + objects.size()));
        }
        return objects;
    }

    @Override
    public Map<String, ModelObject> getAllObjectsByFilter(ModelPersistenceContext context, String objectTypeId, String filter) throws ModelObjectPersisterException {
        HashMap<String, ModelObject> objects = new HashMap<String, ModelObject>(128, 1.0f);
        for (ModelObjectPersister persister : this.persisters) {
            Map<String, ModelObject> map = persister.getAllObjectsByFilter(context, objectTypeId, filter);
            objects.putAll(map);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAllObjects by filter: " + filter + " returned set of size: " + objects.size()));
        }
        return objects;
    }

    @Override
    public long getTimestamp(ModelPersistenceContext context, String objectTypeId, String objectId) throws ModelObjectPersisterException {
        long timestamp = -1L;
        for (ModelObjectPersister persister : this.persisters) {
            if (!persister.hasObject(context, objectTypeId, objectId)) continue;
            timestamp = persister.getTimestamp(context, objectTypeId, objectId);
            break;
        }
        return timestamp;
    }

    @Override
    public void init(ModelPersistenceContext context) {
        boolean initialisedDefaultPersister = false;
        for (ModelObjectPersister persister : this.persisters) {
            if (persister.equals(this.defaultPersister)) {
                initialisedDefaultPersister = true;
            }
            persister.init(context);
        }
        if (!initialisedDefaultPersister) {
            this.defaultPersister.init(context);
            this.persisters.add(this.defaultPersister);
        }
    }

    @Override
    public void invalidateCache() {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).invalidateCache();
        }
    }

    @Override
    public void setCache(boolean cache) {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).setCache(cache);
        }
    }

    @Override
    public void setCacheCheckDelay(int cacheCheckDelay) {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).setCacheCheckDelay(cacheCheckDelay);
        }
    }

    @Override
    public void setCacheMaxSize(int cacheMaxSize) {
        for (ModelObjectPersister persister : this.persisters) {
            if (!(persister instanceof CachedPersister)) continue;
            ((CachedPersister)((Object)persister)).setCacheMaxSize(cacheMaxSize);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        int i = 0;
        for (ModelObjectPersister p : this.persisters) {
            if (i == 0) {
                out.append("[");
            }
            out.append(p.toString());
            if (i < this.persisters.size() - 1) {
                out.append(", ");
            }
            if (i == this.persisters.size() - 1) {
                out.append("]");
            }
            ++i;
        }
        return out.toString();
    }

    @Override
    public boolean hasReadOnlyStore() {
        return this.defaultPersister.hasReadOnlyStore();
    }
}

