/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkView;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.types.TemplateInstance;

public class TemplateView
extends AbstractWebFrameworkView {
    public TemplateView(WebFrameworkConfigElement webFrameworkConfiguration, ModelObjectService modelObjectService, ResourceService resourceService, RenderService renderService, TemplatesContainer templatesContainer) {
        super(webFrameworkConfiguration, modelObjectService, resourceService, renderService, templatesContainer);
    }

    public TemplateView(WebFrameworkServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    @Override
    protected void renderView(RequestContext context) throws Exception {
        this.dispatchTemplate(context);
    }

    public void dispatchTemplate(RequestContext context) throws RequestDispatchException {
        TemplateInstance templateInstance = context.getTemplate();
        if (templateInstance != null) {
            this.getRenderService().renderTemplate(context, RenderFocus.BODY);
        } else {
            try {
                this.getRenderService().renderSystemPage(context, "page-content-association-missing");
            }
            catch (RendererExecutionException e) {
                throw new RequestDispatchException(e);
            }
        }
    }

    @Override
    protected void validateRequestContext(RequestContext context, HttpServletRequest request) throws Exception {
        String templateId = this.getUrl();
        TemplateInstance templateInstance = this.getObjectService().getTemplate(templateId);
        if (templateInstance != null) {
            context.setTemplate(templateInstance);
        }
    }
}

