/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Locale;
import java.util.Map;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkView;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkViewResolver;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.mvc.SystemPageView;
import org.springframework.extensions.surf.mvc.TemplateView;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceLoader;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.ContentAssociation;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.webscripts.ScriptResource;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class ObjectViewResolver
extends AbstractWebFrameworkViewResolver {
    private static final String URI_PREFIX_OBJECT = "obj";

    @Override
    protected boolean canHandle(String viewName, Locale locale) {
        String objectId;
        boolean canHandle = false;
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if ((viewName.startsWith("obj/") || viewName.equals(URI_PREFIX_OBJECT)) && (objectId = context.getParameter("o")) != null) {
            String[] ids = this.getWebFrameworkResourceService().getResourceDescriptorIds(objectId);
            ResourceLoader resourceLoader = this.getWebFrameworkResourceService().getResourceLoader(ids[0], ids[1]);
            canHandle = resourceLoader != null;
        }
        return canHandle;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        AbstractWebFrameworkView view = null;
        if (viewName.startsWith("obj/") || URI_PREFIX_OBJECT.equals(viewName)) {
            RequestContext context = ThreadLocalRequestContext.getRequestContext();
            String resourceId = context.getParameter("o");
            Resource resource = this.getWebFrameworkResourceService().getResource(resourceId);
            if (resource != null) {
                context.setCurrentObject(resource);
                String objectTypeId = resource.getObjectTypeId();
                Map<String, ModelObject> objects = this.getModelObjectService().findContentAssociations(objectTypeId, null, null, null, null);
                if (objects.size() > 0) {
                    ContentAssociation association = (ContentAssociation)objects.values().iterator().next();
                    ModelObject o = association.getObject(context);
                    if (o != null) {
                        if (o instanceof TemplateInstance) {
                            view = new TemplateView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
                            view.setUrl(o.getId());
                        }
                        if (o instanceof Page) {
                            view = new PageView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
                            view.setUrl(o.getId());
                        }
                    }
                } else {
                    context.setValue("resource", new ScriptResource(context, resource));
                    view = new SystemPageView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
                    view.setUrl("page-content-association-missing");
                }
            }
        }
        return view;
    }
}

