/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class LogoutController
extends AbstractController {
    public static final String REDIRECT_URL_PARAMETER = "redirectURL";
    public static final String REDIRECT_URL_PARAMETER_QUERY_KEY = "redirectURLQueryKey";
    public static final String REDIRECT_URL_PARAMETER_QUERY_VALUE = "redirectURLQueryValue";

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationUtil.logout(request, response);
        response.setStatus(401);
        Object redirectURL = request.getParameter(REDIRECT_URL_PARAMETER);
        if (redirectURL != null) {
            String[] keys = request.getParameterValues(REDIRECT_URL_PARAMETER_QUERY_KEY);
            String[] values = request.getParameterValues(REDIRECT_URL_PARAMETER_QUERY_VALUE);
            if (keys != null && values != null && keys.length > 0 && keys.length == values.length) {
                for (int i = 0; i < keys.length; ++i) {
                    String delim = i == 0 ? "?" : "&";
                    redirectURL = (String)redirectURL + delim + keys[i] + "=" + values[i];
                }
            }
            response.setHeader("Location", (String)redirectURL);
        } else {
            response.setHeader("Location", request.getContextPath());
        }
        return null;
    }
}

