/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.ScriptProcessorFactory;
import org.springframework.extensions.webscripts.ScriptProcessorRegistry;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.processor.AbstractScriptProcessor;

public class ScriptProcessorRegistrar
implements ApplicationContextAware {
    private static final String WEBSCRIPTS_SCRIPT_REGISTRY_ID = "webframework.webscripts.registry.scriptprocessor";
    private static final String TEMPLATES_SCRIPT_REGISTRY_ID = "webframework.templates.registry.scriptprocessor";
    private static final String WEBSCRIPTS_SEARCHPATH_ID = "webframework.webscripts.searchpath";
    private static final String TEMPLATES_SEARCHPATH_ID = "webframework.templates.searchpath";
    private ApplicationContext applicationContext;
    private ScriptProcessorRegistry webscriptsRegistry;
    private ScriptProcessorRegistry templatesRegistry;
    private ScriptProcessorFactory factory;
    private SearchPath webscriptsSearchPath;
    private SearchPath templatesSearchPath;
    private String name;
    private String extension;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setWebScriptsRegistry(ScriptProcessorRegistry webscriptsRegistry) {
        this.webscriptsRegistry = webscriptsRegistry;
    }

    public void setTemplatesRegistry(ScriptProcessorRegistry templatesRegistry) {
        this.templatesRegistry = templatesRegistry;
    }

    public void setFactory(ScriptProcessorFactory factory) {
        this.factory = factory;
    }

    public void setWebscriptsSearchPath(SearchPath webscriptsSearchPath) {
        this.webscriptsSearchPath = webscriptsSearchPath;
    }

    public void setTemplatesSearchPath(SearchPath templatesSearchPath) {
        this.templatesSearchPath = templatesSearchPath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void init() {
        if (this.webscriptsRegistry == null) {
            this.webscriptsRegistry = (ScriptProcessorRegistry)this.applicationContext.getBean(WEBSCRIPTS_SCRIPT_REGISTRY_ID);
        }
        if (this.templatesRegistry == null) {
            this.templatesRegistry = (ScriptProcessorRegistry)this.applicationContext.getBean(TEMPLATES_SCRIPT_REGISTRY_ID);
        }
        if (this.factory != null) {
            ScriptProcessor scriptProcessor1 = this.factory.newInstance();
            if (this.webscriptsSearchPath == null) {
                this.webscriptsSearchPath = (SearchPath)this.applicationContext.getBean(WEBSCRIPTS_SEARCHPATH_ID);
            }
            if (scriptProcessor1 instanceof AbstractScriptProcessor) {
                ((AbstractScriptProcessor)scriptProcessor1).setSearchPath(this.webscriptsSearchPath);
            }
            this.webscriptsRegistry.registerScriptProcessor(scriptProcessor1, this.extension, this.name);
            ScriptProcessor scriptProcessor2 = this.factory.newInstance();
            if (this.templatesSearchPath == null) {
                this.templatesSearchPath = (SearchPath)this.applicationContext.getBean(TEMPLATES_SEARCHPATH_ID);
            }
            if (scriptProcessor2 instanceof AbstractScriptProcessor) {
                ((AbstractScriptProcessor)scriptProcessor2).setSearchPath(this.templatesSearchPath);
            }
            this.templatesRegistry.registerScriptProcessor(scriptProcessor2, this.extension, this.name);
        }
    }
}

