/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.util.CacheReport;
import org.springframework.extensions.surf.util.CacheReporter;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class I18nDependencyHandler
implements CacheReporter {
    private DependencyHandler dependencyHandler;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private ReentrantReadWriteLock bundleCacheLock = new ReentrantReadWriteLock();
    private Map<String, Map<Locale, Map<String, Object>>> bundleCache = new HashMap<String, Map<Locale, Map<String, Object>>>();

    public String generateI18nJavaScript(Map<String, DojoDependencies> dependencyMap) {
        StringBuilder content = new StringBuilder();
        Map<String, Map<String, Object>> m = this.generateScopeToBundleMap(dependencyMap);
        String globalMessagesObject = this.webFrameworkConfigElement.getDojoMessagesObject();
        content.append("if (typeof ");
        content.append(globalMessagesObject);
        content.append(" === 'undefined') {\n   ");
        content.append(globalMessagesObject);
        content.append(" = {};\n}\nif(");
        content.append(globalMessagesObject);
        content.append(".messages == null) {\n   ");
        content.append(globalMessagesObject);
        content.append(".messages = {};\n}\nif(");
        content.append(globalMessagesObject);
        content.append(".messages.global == null) {\n   ");
        content.append(globalMessagesObject);
        content.append(".messages.global = ");
        StringBuilderWriter writer = new StringBuilderWriter(8192);
        JSONWriter out = new JSONWriter((Writer)writer);
        try {
            out.startObject();
            Map messages = I18NUtil.getAllMessages((Locale)I18NUtil.parseLocale((String)I18NUtil.getLocale().toString()));
            for (Map.Entry entry : messages.entrySet()) {
                out.writeValue((String)entry.getKey(), (String)entry.getValue());
            }
            out.endObject();
            writer.write(";\r\n");
        }
        catch (IOException jsonErr) {
            throw new WebScriptException("Error building messages response.", (Throwable)jsonErr);
        }
        content.append(writer.toString());
        content.append("\n}\n");
        content.append(globalMessagesObject);
        content.append(".messages.defaultScope = '");
        content.append(this.webFrameworkConfigElement.getDojoMessagesDefaultScope());
        content.append("';\n");
        content.append("if(");
        content.append(globalMessagesObject);
        content.append(".messages.scope == null) {\n   ");
        content.append(globalMessagesObject);
        content.append(".messages.scope = {};\n}\n");
        for (Map.Entry<String, Map<String, Object>> e : m.entrySet()) {
            if (e.getValue() == null) continue;
            String msgs = JSONWriter.encodeToJSON(e.getValue());
            content.append("var cScope = ");
            content.append(msgs);
            content.append(";\n   if (");
            content.append(globalMessagesObject);
            content.append(".messages.scope['");
            content.append(e.getKey());
            content.append("']) {\n   for (var key in cScope) { \n      ");
            content.append(globalMessagesObject);
            content.append(".messages.scope['");
            content.append(e.getKey());
            content.append("'][key] = cScope[key];\n}\n}\nelse {\n   ");
            content.append(globalMessagesObject);
            content.append(".messages.scope['");
            content.append(e.getKey());
            content.append("'] = ");
            content.append(msgs);
            content.append(";\n}\n");
        }
        return content.toString();
    }

    public Map<String, Map<String, Object>> generateScopeToBundleMap(Map<String, DojoDependencies> dependencyMap) {
        HashMap<String, Map<String, Object>> scopeToMapMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, DojoDependencies> deps : dependencyMap.entrySet()) {
            Set<DojoDependencies.I18nDependency> i18nDeps;
            DojoDependencies currDeps = deps.getValue();
            if (currDeps == null || (i18nDeps = currDeps.getI18nDeps()) == null) continue;
            for (DojoDependencies.I18nDependency i18nDep : deps.getValue().getI18nDeps()) {
                Map<String, Object> bundleMap = this.getLocaleMergedBundle(i18nDep.getPath());
                if (bundleMap == null) continue;
                String scope = i18nDep.getScope();
                HashMap<String, Object> mergedBundlesForScope = (HashMap<String, Object>)scopeToMapMap.get(scope);
                if (mergedBundlesForScope == null) {
                    mergedBundlesForScope = new HashMap<String, Object>();
                    scopeToMapMap.put(scope, mergedBundlesForScope);
                }
                mergedBundlesForScope.putAll(bundleMap);
            }
        }
        return scopeToMapMap;
    }

    public Map<String, Object> getLocaleMergedBundle(String path) {
        Locale locale = I18NUtil.getLocale();
        Map<String, Object> mergedBundles = this.getCachedBundle(path, locale);
        if (mergedBundles == null) {
            int lastFullStop;
            String languagePath = null;
            String countryPath = null;
            String variantPath = null;
            if (path != null && (lastFullStop = path.lastIndexOf(".")) != -1) {
                String prefix = path.substring(0, lastFullStop);
                String suffix = path.substring(lastFullStop);
                if (!locale.getLanguage().equals("")) {
                    languagePath = prefix + "_" + locale.getLanguage() + suffix;
                    if (!locale.getCountry().equals("")) {
                        countryPath = prefix + "_" + locale.getLanguage() + "_" + locale.getCountry() + suffix;
                        if (!locale.getVariant().equals("")) {
                            variantPath = prefix + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant() + suffix;
                        }
                    }
                }
            }
            ResourceBundle defaultBundle = this.getBundle(path);
            ResourceBundle languageBundle = this.getBundle(languagePath);
            ResourceBundle countryBundle = this.getBundle(countryPath);
            ResourceBundle variantBundle = this.getBundle(variantPath);
            mergedBundles = new HashMap<String, Object>();
            this.mergeBundle(mergedBundles, defaultBundle);
            this.mergeBundle(mergedBundles, languageBundle);
            this.mergeBundle(mergedBundles, countryBundle);
            this.mergeBundle(mergedBundles, variantBundle);
            this.cacheBundle(path, locale, mergedBundles);
        }
        return mergedBundles;
    }

    protected ResourceBundle getBundle(String path) {
        PropertyResourceBundle b = null;
        try {
            InputStream in;
            if (path != null && (in = this.dependencyHandler.getResourceInputStream(path)) != null) {
                b = new PropertyResourceBundle(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b;
    }

    protected void mergeBundle(Map<String, Object> mergedBundles, ResourceBundle bundleToMerge) {
        if (mergedBundles != null && bundleToMerge != null) {
            Enumeration<String> keys = bundleToMerge.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                mergedBundles.put(key, bundleToMerge.getObject(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getCachedBundle(String path, Locale locale) {
        Map<String, Object> b = null;
        this.bundleCacheLock.readLock().lock();
        try {
            Map<Locale, Map<String, Object>> m = this.bundleCache.get(path);
            if (m != null) {
                b = m.get(locale);
            }
        }
        finally {
            this.bundleCacheLock.readLock().unlock();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheBundle(String path, Locale locale, Map<String, Object> s) {
        this.bundleCacheLock.writeLock().lock();
        try {
            Map<Locale, Map<String, Object>> m = this.bundleCache.get(path);
            if (m == null) {
                m = new HashMap<Locale, Map<String, Object>>();
                this.bundleCache.put(path, m);
            }
            m.put(locale, s);
        }
        finally {
            this.bundleCacheLock.writeLock().unlock();
        }
    }

    @Override
    public void clearCaches() {
        this.bundleCacheLock.writeLock().lock();
        try {
            this.bundleCache.clear();
        }
        finally {
            this.bundleCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheReport> report() {
        ArrayList<CacheReport> reports = new ArrayList<CacheReport>(3);
        long size = 0L;
        this.bundleCacheLock.writeLock().lock();
        try {
            for (Map<Locale, Map<String, Object>> m : this.bundleCache.values()) {
                for (Map<String, Object> b : m.values()) {
                    for (Object o : b.values()) {
                        size += (long)(((String)o).length() * 2 + 64);
                    }
                }
            }
            reports.add(new CacheReport("bundleCache", this.bundleCache.size(), size));
        }
        finally {
            this.bundleCacheLock.writeLock().unlock();
        }
        return reports;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public WebFrameworkConfigElement getWebFrameworkConfigElement() {
        return this.webFrameworkConfigElement;
    }

    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }
}

