/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.extensions.surf.util.URLDecoder;

public final class WebUtil {
    public static Map<String, String> buildQueryStringMap(HttpServletRequest request) {
        return WebUtil.buildQueryStringMap(request.getQueryString());
    }

    public static Map<String, String> buildQueryStringMap(String queryString) {
        HashMap<String, String> map = new HashMap<String, String>(8, 1.0f);
        if (queryString != null) {
            StringTokenizer t = new StringTokenizer(queryString, "&");
            while (t.hasMoreTokens()) {
                String combo = t.nextToken();
                int c = combo.indexOf(61);
                if (c <= -1) continue;
                String value = URLDecoder.decode((String)combo.substring(c + 1, combo.length()));
                map.put(combo.substring(0, c), value);
            }
        }
        return map;
    }

    public static String getQueryStringForMap(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(32);
        for (String key : map.keySet()) {
            String value = map.get(key);
            if (result.length() != 0) {
                result.append('&');
            }
            result.append(key).append('=').append(value);
        }
        return result.toString();
    }
}

