/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.site;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.util.URLEncoder;

public class AuthenticationUtil {
    private static final String COOKIE_ALFLOGIN = "alfLogin";
    private static final String COOKIE_ALFUSER = "alfUsername3";
    private static final int TIMEOUT = 604800;
    private static final String MT_GUEST_PREFIX = "guest@";
    private static final String HTTP_SECURED_SESSION_PROP = "http.secured.session";
    private static final String COOKIES_SAMESITE = "cookies.sameSite";

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().invalidate();
        if (response != null) {
            String sameSite;
            String userCookie = "alfUsername3=; Path=" + request.getContextPath() + "; Max-Age=0;";
            boolean securedSession = AuthenticationUtil.getHttpSecuredSession();
            if (securedSession) {
                userCookie = userCookie + " Secure; HttpOnly;";
            }
            if ((sameSite = System.getProperty(COOKIES_SAMESITE)) != null) {
                userCookie = userCookie + " SameSite=" + sameSite + ";";
            }
            response.addHeader("Set-Cookie", userCookie);
        }
    }

    public static void login(HttpServletRequest request, String userId) {
        AuthenticationUtil.login(request, null, userId, true);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String userId) {
        AuthenticationUtil.login(request, response, userId, true);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String userId, boolean logout) {
        AuthenticationUtil.login(request, response, userId, logout, true);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String userId, boolean logout, boolean setLoginCookies) {
        String currentUserId;
        if (logout && (currentUserId = (String)request.getSession().getAttribute("_alf_USER_ID")) != null) {
            AuthenticationUtil.logout(request, response);
        }
        request.getSession().setAttribute("_alf_USER_ID", (Object)userId);
        boolean securedSession = AuthenticationUtil.getHttpSecuredSession();
        String sameSite = System.getProperty(COOKIES_SAMESITE);
        if (response != null && securedSession) {
            String cookie = "JSESSIONID=" + request.getSession().getId() + "; Path=" + request.getContextPath() + "; HttpOnly; Secure;";
            if (sameSite != null) {
                cookie = cookie + " SameSite=" + sameSite + ";";
            }
            response.addHeader("Set-Cookie", cookie);
        }
        if (response != null && setLoginCookies) {
            long timeInSeconds = System.currentTimeMillis() / 1000L;
            String loginCookie = "alfLogin=" + Long.toString(timeInSeconds) + "; Path=" + request.getContextPath() + "; Max-Age=604800;";
            if (securedSession) {
                loginCookie = loginCookie + " Secure; HttpOnly;";
            }
            if (sameSite != null) {
                loginCookie = loginCookie + " SameSite=" + sameSite + ";";
            }
            response.addHeader("Set-Cookie", loginCookie);
            if (!AuthenticationUtil.isGuest(userId)) {
                String userCookie = "alfUsername3=" + URLEncoder.encode((String)userId) + "; Path=" + request.getContextPath() + "; Max-Age=604800;";
                if (securedSession) {
                    userCookie = userCookie + " Secure; HttpOnly;";
                }
                if (sameSite != null) {
                    userCookie = userCookie + " SameSite=" + sameSite + ";";
                }
                response.addHeader("Set-Cookie", userCookie);
            }
        }
    }

    public static void clearUserContext(HttpServletRequest request) {
        request.getSession().removeAttribute("_alf_USER_ID");
        request.getSession().removeAttribute("_alf_USER_OBJECT");
    }

    public static boolean isAuthenticated(HttpServletRequest request) {
        String userId = (String)request.getSession().getAttribute("_alf_USER_ID");
        return userId != null && !AuthenticationUtil.isGuest(userId);
    }

    public static boolean isGuest(String userId) {
        return userId != null && ("guest".equals(userId) || userId.startsWith(MT_GUEST_PREFIX));
    }

    public static boolean isExternalAuthentication(HttpServletRequest request) {
        return request.getSession().getAttribute("_alfExternalAuth") != null;
    }

    public static boolean isAimsAuthentication(HttpServletRequest request) {
        return request.getSession().getAttribute("_alfExternalAuthAIMS") != null;
    }

    public static String getUserId(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("_alf_USER_ID");
    }

    public static Cookie getLastLoginCookie(HttpServletRequest request) {
        return AuthenticationUtil.getCookie(request, COOKIE_ALFLOGIN);
    }

    public static Cookie getUsernameCookie(HttpServletRequest request) {
        return AuthenticationUtil.getCookie(request, COOKIE_ALFUSER);
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!name.equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
        }
        return cookie;
    }

    private static boolean getHttpSecuredSession() {
        return Boolean.parseBoolean(System.getProperty(HTTP_SECURED_SESSION_PROP));
    }
}

