/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource.support;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.resource.AbstractResource;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.resource.ResourceContentImpl;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;

public class VirtualizedWebappResource
extends AbstractResource {
    private static Log logger = LogFactory.getLog(VirtualizedWebappResource.class);

    public VirtualizedWebappResource(String protocolId, String endpointId, String objectId, FrameworkBean frameworkUtil) {
        super(protocolId, endpointId, objectId, frameworkUtil);
    }

    @Override
    public ResourceContent getMetadata() throws IOException {
        return null;
    }

    @Override
    public String getMetadataURL() {
        return null;
    }

    @Override
    public ResourceContent getContent() throws IOException {
        return new ResourceContentImpl(this, this.getContentURL(), this.frameworkUtil);
    }

    @Override
    public String getContentURL() {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        String contentURL = context.getContextPath() + "/res" + this.getObjectId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Formed virtual content url: " + contentURL));
        }
        return contentURL;
    }

    @Override
    public String getObjectTypeId() {
        String extension = null;
        int i = this.getContentURL().lastIndexOf(".");
        if (i > -1) {
            extension = this.getContentURL().substring(i + 1);
        }
        return extension;
    }

    public String getResourceTypeId() {
        return "webapp";
    }

    @Override
    public boolean isContainer() {
        return false;
    }
}

