/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.Processor;
import org.springframework.extensions.surf.render.ProcessorContext;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.webscripts.ProcessorModelHelper;

public abstract class AbstractProcessor
implements Processor {
    private static Log logger = LogFactory.getLog(AbstractProcessor.class);
    protected ProcessorModelHelper processorModelHelper;

    public void setProcessorModelHelper(ProcessorModelHelper processorModelHelper) {
        this.processorModelHelper = processorModelHelper;
    }

    @Override
    public void execute(ProcessorContext processorContext, ModelObject object, RenderFocus focus) throws RendererExecutionException {
        if (focus == null || focus == RenderFocus.BODY) {
            this.executeBody(processorContext, object);
        } else if (focus == RenderFocus.ALL) {
            this.executeHeader(processorContext, object);
            this.executeBody(processorContext, object);
        } else if (focus == RenderFocus.HEADER) {
            this.executeHeader(processorContext, object);
        }
    }

    @Override
    public void executeHeader(ProcessorContext processorContext, ModelObject object) throws RendererExecutionException {
    }

    @Override
    public abstract void executeBody(ProcessorContext var1, ModelObject var2) throws RendererExecutionException;

    protected ProcessorContext.ProcessorDescriptor getRenderingDescriptor(ProcessorContext processorContext) {
        RequestContext context = processorContext.getRequestContext();
        RenderMode renderMode = context.getRenderMode();
        ProcessorContext.ProcessorDescriptor processDescriptor = processorContext.getDescriptor(renderMode);
        if (processDescriptor == null && renderMode != RenderMode.VIEW) {
            logger.warn((Object)("Could not retrieve ProcessDescriptor for RenderMode: " + String.valueOf((Object)renderMode) + ", attempting to retrieve using RenderMode: VIEW"));
            processDescriptor = processorContext.getDescriptor(RenderMode.VIEW);
        }
        return processDescriptor;
    }

    protected String getProperty(ProcessorContext processorContext, String propertyName) {
        ProcessorContext.ProcessorDescriptor descriptor = this.getRenderingDescriptor(processorContext);
        String value = descriptor.get(propertyName);
        if (value != null) {
            String modeViewUri = this.getScalarProperty(processorContext, "uri", RenderMode.VIEW);
            if (value.indexOf("${mode.view.uri}") != -1) {
                value = value.replace("${mode.view.uri}", modeViewUri);
            }
        }
        return value;
    }

    private String getScalarProperty(ProcessorContext processorContext, String propertyName, RenderMode renderMode) {
        ProcessorContext.ProcessorDescriptor descriptor = processorContext.getDescriptor(renderMode);
        return descriptor.get(propertyName);
    }
}

