/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.mvc.UrlViewController;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.CredentialsImpl;
import org.springframework.web.servlet.ModelAndView;

public class FeedController
extends UrlViewController {
    private static final String ENDPOINT_ALFRESCO_FEED = "alfresco-feed";
    protected ConnectorService connectorService;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) {
        String authorization = req.getHeader("Authorization");
        if (authorization == null || authorization.length() == 0) {
            try {
                this.authorizedResponseStatus(res);
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String[] authParts = authorization.split(" ");
        if (authParts[0].equalsIgnoreCase("negotiate")) {
            try {
                this.authorizedResponseStatus(res);
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!authParts[0].equalsIgnoreCase("basic")) {
            throw new WebScriptsPlatformException("Authorization '" + authParts[0] + "' not supported.");
        }
        String[] values = new String(Base64.decode((String)authParts[1])).split(":");
        if (values.length == 2) {
            try {
                CredentialsImpl credentials = new CredentialsImpl(ENDPOINT_ALFRESCO_FEED);
                String username = values[0];
                credentials.setProperty("cleartextUsername", (Object)username);
                credentials.setProperty("cleartextPassword", (Object)values[1]);
                CredentialVault vault = this.connectorService.getCredentialVault(req.getSession(), username);
                vault.store((Credentials)credentials);
                req.getSession().setAttribute("_alf_USER_ID", (Object)username);
                RequestContext context = ThreadLocalRequestContext.getRequestContext();
                context.getAttributes().put("alfUserEndpoint", (Serializable)((Object)ENDPOINT_ALFRESCO_FEED));
                res.setHeader("Cache-Control", "max-age=600, must-revalidate");
                return super.handleRequestInternal(req, res);
            }
            catch (Exception err) {
                throw new WebScriptsPlatformException("Failed to provision connector.", (Throwable)err);
            }
        }
        try {
            this.authorizedResponseStatus(res);
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void authorizedResponseStatus(HttpServletResponse res) throws IOException {
        res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
        res.sendError(401, "Requested endpoint requires authentication.");
    }
}

