/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractLoginController
extends AbstractController {
    protected static final String PARAM_PASSWORD = "password";
    protected static final String PARAM_USERNAME = "username";
    private UserFactory userFactory;
    private WebFrameworkConfigElement webFrameworkConfiguration;

    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public void setWebFrameworkConfiguration(WebFrameworkConfigElement webFrameworkConfiguration) {
        this.webFrameworkConfiguration = webFrameworkConfiguration;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setCharacterEncoding("UTF-8");
        String username = request.getParameter(PARAM_USERNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        boolean success = false;
        try {
            HttpSession session = request.getSession(false);
            AuthenticationUtil.logout(request, response);
            boolean authenticated = this.userFactory.authenticate(request, username, password);
            if (authenticated) {
                AuthenticationUtil.login(request, response, username, false, this.webFrameworkConfiguration.isLoginCookiesEnabled());
                success = true;
            }
        }
        catch (Throwable err) {
            throw new ServletException(err);
        }
        if (success) {
            this.onSuccess(request, response);
        } else {
            this.onFailure(request, response);
        }
        return null;
    }

    protected abstract void onFailure(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract void onSuccess(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

