/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.WebUtil;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptForm;
import org.springframework.extensions.webscripts.ScriptableMap;

public final class ScriptFormData
extends ScriptBase {
    private Map<String, FormField> fields;
    private final RequestContext renderContext;
    private ModelObject object;

    public ScriptFormData(RequestContext context, ModelObject object) {
        super(context);
        this.renderContext = context;
        this.object = object;
        this.load(ScriptForm.getPrefix(this.renderContext, object));
    }

    protected ScriptableMap buildProperties() {
        return null;
    }

    public FormField getField(String id) {
        return this.fields.get(id);
    }

    public Object[] getFields() {
        Object[] array = new Object[this.fields.size()];
        int i = 0;
        for (String key : this.fields.keySet()) {
            FormField field = this.fields.get(key);
            array[i] = field;
            ++i;
        }
        return array;
    }

    public String[] getFieldIds() {
        return this.fields.keySet().toArray(new String[this.fields.keySet().size()]);
    }

    public void load(String prefix) {
        this.fields = new HashMap<String, FormField>(16, 1.0f);
        try {
            Content c = this.context.getRequestContent();
            if (c != null) {
                String content = c.getContent();
                if (content != null && content.length() > 0) {
                    Map<String, String> multiPartMap = WebUtil.buildQueryStringMap(content);
                    this.processMapIntoFields(multiPartMap, prefix);
                }
                Map<String, String> requestParametersMap = this.renderContext.getParameters();
                this.processMapIntoFields(requestParametersMap, prefix);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void processMapIntoFields(Map map, String prefix) {
        if (map != null) {
            for (String prefixedId : map.keySet()) {
                Object value;
                if (prefix != null && (prefix == null || !prefixedId.startsWith(prefix)) || !((value = map.get(prefixedId)) instanceof String)) continue;
                FormField field = new FormField(prefixedId, value);
                this.fields.put(prefixedId, field);
            }
        }
    }

    public class FormField
    implements Serializable {
        private String id;
        private Object value;

        public FormField(String id) {
            this.id = id;
        }

        public FormField(String id, Object value) {
            this(id);
            this.value = value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String getId() {
            return ScriptForm.unprefix(this.id);
        }
    }
}

