/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.AbstractRuntime;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.LocalWebScriptContext;
import org.springframework.extensions.webscripts.LocalWebScriptRequest;
import org.springframework.extensions.webscripts.LocalWebScriptResponse;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptSessionFactory;

public class LocalWebScriptRuntime
extends AbstractRuntime {
    public static final String DEFAULT_METHOD_GET = "GET";
    private ServerProperties serverProperties;
    private LocalWebScriptContext context;
    private Writer out;
    private String method;

    public LocalWebScriptRuntime(Writer out, RuntimeContainer container, ServerProperties serverProps, LocalWebScriptContext context) {
        super(container);
        this.out = out;
        this.serverProperties = serverProps;
        this.context = context;
        this.method = DEFAULT_METHOD_GET;
    }

    public LocalWebScriptContext getLocalContext() {
        return this.context;
    }

    public String getName() {
        return "SURF Web Framework Runtime";
    }

    protected String getScriptUrl() {
        return this.context.getScriptUrl();
    }

    protected WebScriptRequest createRequest(Match match) {
        Map<String, Serializable> properties = this.context.getModelObject().getProperties();
        String scriptUrl = this.context.getExecuteUrl();
        ModelObject modelObject = this.context.getModelObject();
        properties.put("id", (Serializable)((Object)modelObject.getId()));
        this.addProperties(properties, modelObject.getCustomProperties());
        this.addProperties(properties, this.context.getRequestContext().getEvaluatedProperties());
        String htmlBindingId = (String)((Object)this.context.getRequestContext().getValue("htmlid"));
        if (htmlBindingId != null) {
            properties.put("htmlid", (Serializable)((Object)htmlBindingId));
        }
        return new LocalWebScriptRequest((Runtime)this, scriptUrl, match, properties, this.serverProperties, this.context);
    }

    private void addProperties(Map<String, Serializable> base, Map<String, Serializable> toMerge) {
        for (Map.Entry<String, Serializable> prop : toMerge.entrySet()) {
            base.put(prop.getKey(), (Serializable)((Object)UriUtils.replaceTokens((String)((Object)prop.getValue()), this.context.getRequestContext(), null, null, "")));
        }
    }

    protected LocalWebScriptResponse createResponse() {
        return new LocalWebScriptResponse((Runtime)this, this.context, this.out);
    }

    protected String getScriptMethod() {
        return this.method;
    }

    protected Authenticator createAuthenticator() {
        return null;
    }

    public WebScriptSessionFactory createSessionFactory() {
        return null;
    }

    public void setScriptMethod(String method) {
        this.method = method;
    }

    protected boolean beforeProcessError(Match match, Throwable e) {
        if (e instanceof WebScriptException && ((WebScriptException)e).getStatus() == 404) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage());
            }
            return false;
        }
        return super.beforeProcessError(match, e);
    }
}

