/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class XhrDependencies
extends DeclarativeWebScript {
    private DependencyAggregator dependencyAggregator;

    protected LinkedHashSet<String> buildHashSet(String[] input) {
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        if (input != null) {
            for (String value : input) {
                if (value.startsWith("/")) {
                    value = value.substring(1);
                }
                output.add(value);
            }
        }
        return output;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String[] cssDeps;
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        String jsResource = "";
        String cssResource = "";
        String[] jsDeps = req.getParameterValues("js");
        if (jsDeps != null && jsDeps.length > 0) {
            jsResource = this.dependencyAggregator.generateJavaScriptDependencies(this.buildHashSet(jsDeps));
        }
        if ((cssDeps = req.getParameterValues("css")) != null && cssDeps.length > 0) {
            cssResource = this.dependencyAggregator.generateCSSDependencies(this.buildHashSet(cssDeps));
        }
        model.put("jsResource", jsResource);
        model.put("cssResource", cssResource);
        return model;
    }

    public DependencyAggregator getDependencyAggregator() {
        return this.dependencyAggregator;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }
}

