/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class PostClientSideError
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(PostClientSideError.class);

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        try {
            JSONParser jp;
            Object o;
            String content = req.getContent().getContent();
            if (content.length() > 0 && (o = (jp = new JSONParser()).parse(content)) instanceof JSONObject) {
                JSONObject jsonData = (JSONObject)o;
                String callerName = (String)jsonData.get((Object)"callerName");
                JSONArray messageArgs = (JSONArray)jsonData.get((Object)"messageArgs");
                String userName = (String)jsonData.get((Object)"userName");
                String location = (String)jsonData.get((Object)"location");
                StringBuilder sb = new StringBuilder();
                sb.append("The following client-side error has been reported:");
                sb.append("\n   user: " + userName);
                sb.append("\n   page: " + location);
                sb.append("\n   callerName: " + callerName);
                sb.append("\n   messageArgs: " + messageArgs.toString());
                logger.error((Object)sb.toString());
            }
        }
        catch (IOException content) {
        }
        catch (ParseException e) {
            status.setCode(500);
            status.setMessage("An error occurred parsing the client side error");
            status.setException((Throwable)e);
            status.setRedirect(true);
        }
        return model;
    }
}

