/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class FakeBodyContent
extends BodyContent {
    static int DEFAULT_BUFFER_SIZE = 1024;
    static String lineSeparator = System.getProperty("line.separator");
    private JspWriter enclosingWriter;
    private PrintWriter out;
    private char[] buffer;
    private int index;
    private boolean flushed = false;
    public boolean unbounded = false;

    public FakeBodyContent(JspWriter encl) {
        super(encl);
        this.enclosingWriter = encl;
        if (this.bufferSize == -1) {
            this.bufferSize = DEFAULT_BUFFER_SIZE;
        } else if (this.bufferSize == -2) {
            this.bufferSize = DEFAULT_BUFFER_SIZE;
            this.unbounded = true;
        }
        this.buffer = new char[this.bufferSize];
        this.index = 0;
    }

    public void write(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        if (this.bufferSize == 0) {
            this.out.write(s);
        } else {
            if (s != null && s.length() == 0) {
                return;
            }
            if (this.index + s.length() >= this.bufferSize) {
                this.growBuffer(this.index + s.length());
            }
            s.getChars(0, s.length(), this.buffer, this.index);
            this.index += s.length();
        }
    }

    public void write(int i) throws IOException {
        if (this.bufferSize == 0) {
            this.out.write(i);
        } else {
            if (this.index >= this.bufferSize) {
                this.growBuffer(this.bufferSize + 1);
            }
            this.buffer[this.index++] = (char)i;
        }
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.bufferSize == 0) {
            this.out.write(c, off, len);
        } else {
            int end = off + len;
            if (off < 0 || off > c.length || len < 0 || end > c.length || end < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.index + len >= this.bufferSize) {
                this.growBuffer(this.index + len);
            }
            System.arraycopy(c, off, this.buffer, this.index, len);
            this.index += len;
        }
    }

    private void growBuffer(int minLength) {
        int newLength = Math.max(minLength, this.bufferSize * 2);
        char[] newBuf = new char[newLength];
        System.arraycopy(this.buffer, 0, newBuf, 0, this.index);
        this.buffer = newBuf;
        this.bufferSize = newBuf.length;
    }

    public void print(char c) throws IOException {
        this.write(c);
    }

    public void print(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public void print(boolean b) throws IOException {
        this.write(new Boolean(b).toString());
    }

    public void print(long l) throws IOException {
        this.write(Long.toString(l));
    }

    public void print(float f) throws IOException {
        this.write(Float.toString(f));
    }

    public void print(int i) throws IOException {
        this.write(Integer.toString(i));
    }

    public void print(Object o) throws IOException {
        this.write(o.toString());
    }

    public void print(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(char[] c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.println();
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public int getRemaining() {
        return this.bufferSize - this.index;
    }

    public void clear() throws IOException {
        if (this.flushed) {
            throw new IOException("Can't clear flushed buffer");
        }
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        if (this.bufferSize == 0) {
            throw new IllegalStateException("No buffer set");
        }
        this.index = 0;
    }

    public void newLine() throws IOException {
        this.write(lineSeparator);
    }

    public Reader getReader() {
        if (this.flushed) {
            throw new IllegalStateException("The stream has already been flushed");
        }
        return new CharArrayReader(this.buffer, 0, this.index);
    }

    public String getString() {
        if (this.flushed) {
            throw new IllegalStateException("The stream has already been flushed");
        }
        return new String(this.buffer, 0, this.index);
    }

    public void writeOut(Writer out) throws IOException {
        if (this.flushed) {
            throw new IllegalStateException("The stream has already been flushed");
        }
        out.write(this.buffer, 0, this.index);
    }

    public JspWriter getEnclosingWriter() {
        return this.enclosingWriter;
    }

    protected void setEnclosingWriter(JspWriter encl) {
        this.enclosingWriter = encl;
    }
}

