/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.uri;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.webscripts.UriTemplate;

public class UriTemplateMappingIndex {
    private Map<UriTemplate, String> mappings;

    public UriTemplateMappingIndex(ConfigElement config) {
        List mappingElements = config.getChildren("uri-mapping");
        if (mappingElements != null) {
            this.mappings = new LinkedHashMap<UriTemplate, String>(mappingElements.size());
            for (ConfigElement mappingElement : mappingElements) {
                String entry = mappingElement.getChildValue("url-entry");
                if (entry == null || entry.trim().length() == 0) {
                    throw new IllegalArgumentException("<uri-mapping> config element must contain <url-entry> element value.");
                }
                List templateElements = mappingElement.getChildren("uri-template");
                if (templateElements.size() == 0) {
                    throw new IllegalArgumentException("<uri-mapping> config element must contain <uri-template> element(s).");
                }
                for (ConfigElement templateElement : templateElements) {
                    String template = templateElement.getValue();
                    if (template == null || template.trim().length() == 0) {
                        throw new IllegalArgumentException("<uri-template> config element must contain a value.");
                    }
                    UriTemplate uriTemplate = new UriTemplate(template);
                    this.mappings.put(uriTemplate, entry);
                }
            }
        } else {
            this.mappings = Collections.emptyMap();
        }
    }

    public String findMatchAndReplace(String uri) {
        for (UriTemplate template : this.mappings.keySet()) {
            Map match = template.match(uri);
            if (match == null) continue;
            return UriUtils.replaceUriTokens(this.mappings.get(template), match);
        }
        return null;
    }

    public Map<String, String> findMatch(String uri) {
        for (UriTemplate template : this.mappings.keySet()) {
            Map match = template.match(uri);
            if (match == null) continue;
            return match;
        }
        return null;
    }
}

