/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Extension;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.util.XMLUtil;

public class ExtensionImpl
extends AbstractModelObject
implements Extension {
    private static final long serialVersionUID = -7611883161758132916L;
    private static final Log logger = LogFactory.getLog(ExtensionImpl.class);
    public static final String MODULE = "module";
    public static final String MODULE_ID_XPATH_QUERY_OPEN = "/extension//modules//module//id[.= '";
    public static final String MODULE_ID_XPATH_QUERY_CLOSE = "']";
    private List<ExtensionModule> modules = new ArrayList<ExtensionModule>();

    @Override
    public String getTypeId() {
        return "extension";
    }

    public ExtensionImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        List modulesDefinitionList = this.getDocument().getRootElement().elements("modules");
        for (Element modulesDefinition : modulesDefinitionList) {
            List moduleDefinitionList = XMLUtil.getChildren(modulesDefinition);
            for (Element moduleDefinition : moduleDefinitionList) {
                if (!moduleDefinition.getName().equals(MODULE)) continue;
                this.modules.add(new ExtensionModule(moduleDefinition, key));
            }
        }
    }

    @Override
    public List<ExtensionModule> getExtensionModules() {
        return this.modules;
    }

    @Override
    public String getExtensionType() {
        return this.getProperty("extension-type");
    }

    @Override
    public void setExtensionType(String extensionType) {
        this.setProperty("extension-type", extensionType);
    }

    private ModuleObjectAndNode findModule(String id, Document document) {
        ModuleObjectAndNode result = null;
        if (id != null) {
            String xpathQuery;
            Node targetIdNode;
            ExtensionModule targetModule = null;
            Element moduleNode = null;
            List<ExtensionModule> modules = this.getExtensionModules();
            for (ExtensionModule module : modules) {
                if (!id.equals(module.getId())) continue;
                targetModule = module;
                break;
            }
            if ((targetIdNode = document.selectSingleNode(xpathQuery = MODULE_ID_XPATH_QUERY_OPEN + id + MODULE_ID_XPATH_QUERY_CLOSE)) != null) {
                moduleNode = targetIdNode.getParent();
            }
            if (targetModule != null && moduleNode != null) {
                result = new ModuleObjectAndNode(targetModule, (Node)moduleNode);
            }
        }
        return result;
    }

    @Override
    public ExtensionModule addExtensionModule(String xmlFragment) throws DocumentException {
        ExtensionModule createdModule = null;
        Document moduleDoc = XMLUtil.parse(xmlFragment);
        Element newModuleRoot = moduleDoc.getRootElement();
        if (newModuleRoot != null && newModuleRoot.getName().equals(MODULE)) {
            Document extensionDocument;
            Element idEl = newModuleRoot.element("id");
            if (idEl == null) {
                throw new DocumentException("An \"<id>\" element was not present in the XML supplied to create a new ExtensionModule");
            }
            String id = idEl.getTextTrim();
            ModuleObjectAndNode moan = this.findModule(id, extensionDocument = this.getDocument());
            if (moan != null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("An attempt was made to add a new ExtensionModule with the id \"" + id + "\" but an ExtensionModule with that id already exists."));
                }
            } else {
                createdModule = new ExtensionModule(newModuleRoot, this.getKey());
                this.getExtensionModules().add(createdModule);
                Element modulesElement = extensionDocument.getRootElement().element("modules");
                if (modulesElement == null) {
                    modulesElement = extensionDocument.getRootElement().addElement("modules");
                }
                modulesElement.add(newModuleRoot);
                this.updateXML(extensionDocument);
            }
        } else {
            throw new DocumentException("The root element of the XML supplied to create a new ExtensionModule was not \"<module>\"");
        }
        return createdModule;
    }

    @Override
    public ExtensionModule updateExtensionModule(String xmlFragment) throws DocumentException {
        ExtensionModule updatedModule = null;
        Document moduleDoc = XMLUtil.parse(xmlFragment);
        Element moduleRoot = moduleDoc.getRootElement();
        if (moduleRoot != null && moduleRoot.getName().equals(MODULE)) {
            Document extensionDocument;
            Element idEl = moduleRoot.element("id");
            if (idEl == null) {
                throw new DocumentException("An \"<id>\" element was not present in the XML supplied to update an ExtensionModule");
            }
            String id = idEl.getTextTrim();
            ModuleObjectAndNode moan = this.findModule(id, extensionDocument = this.getDocument());
            if (moan != null) {
                updatedModule = new ExtensionModule(moduleRoot, this.getKey());
                this.getExtensionModules().remove((Object)moan.getObject());
                this.getExtensionModules().add(updatedModule);
                Element modulesElement = extensionDocument.getRootElement().element("modules");
                modulesElement.remove(moan.getNode());
                modulesElement.add(moduleRoot);
                this.updateXML(extensionDocument);
            } else if (logger.isErrorEnabled()) {
                logger.error((Object)("An attempt was made to add a update ExtensionModule with the id \"" + id + "\" but no ExtensionModule with that id exists."));
            }
        } else {
            throw new DocumentException("The root element of the XML supplied to create a new ExtensionModule was not \"<module>\"");
        }
        return updatedModule;
    }

    @Override
    public ExtensionModule deleteExtensionModule(String moduleId) {
        ExtensionModule targetModule = null;
        Document extensionDocument = this.getDocument();
        ModuleObjectAndNode moan = this.findModule(moduleId, extensionDocument);
        if (moan != null) {
            if (moan.getObject() != null) {
                this.getExtensionModules().remove((Object)moan.getObject());
                targetModule = moan.getObject();
            }
            if (moan.getNode() != null) {
                moan.getNode().detach();
                this.updateXML(extensionDocument);
            }
        }
        return targetModule;
    }

    public class ModuleObjectAndNode {
        private ExtensionModule object;
        private Node node;

        public ModuleObjectAndNode(ExtensionModule object, Node node) {
            this.object = object;
            this.node = node;
        }

        public ExtensionModule getObject() {
            return this.object;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

