/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.taglib;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public abstract class RenderServiceTag
extends RequestContextAwareTag {
    private static final long serialVersionUID = 8558352373760130809L;
    private static Log logger = LogFactory.getLog(RenderServiceTag.class);
    private RenderService renderService = null;

    protected final int doStartTagInternal() throws Exception {
        int returnCode = 0;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        RequestContext renderContext = (RequestContext)request.getAttribute("renderContext");
        ModelObject object = (ModelObject)request.getAttribute("modelObject");
        if (this.renderService != null) {
            returnCode = this.invokeRenderService(this.renderService, renderContext, object);
        } else {
            try {
                WebApplicationContext applicationContext = this.getRequestContext().getWebApplicationContext();
                String[] renderServices = applicationContext.getBeanNamesForType(RenderService.class);
                if (renderServices.length == 0) {
                    logger.error((Object)("A RenderService bean has not been defined in the Spring application context. It is not possible to render the custom JSP implemented by the class: " + ((Object)((Object)this)).getClass().getName()));
                    this.pageContext.getOut().write("Cannot render " + this.getId() + " because a RenderService bean is not configured in the Spring application context");
                    returnCode = 0;
                } else if (renderServices.length == 1) {
                    this.renderService = (RenderService)applicationContext.getBean(renderServices[0]);
                    returnCode = this.invokeRenderService(this.renderService, renderContext, object);
                } else {
                    logger.info((Object)("Multiple RenderService beans have been configured, searching for instance of " + RenderService.class.getName()));
                    RenderService preferredRenderService = null;
                    RenderService firstRenderService = null;
                    for (String currRenderServiceName : renderServices) {
                        RenderService currRenderService = (RenderService)applicationContext.getBean(currRenderServiceName);
                        if (currRenderService instanceof RenderService) {
                            preferredRenderService = currRenderService;
                            break;
                        }
                        if (firstRenderService != null) continue;
                        firstRenderService = currRenderService;
                    }
                    if (preferredRenderService != null) {
                        logger.info((Object)("Using RenderService bean: \"" + preferredRenderService.getBeanName() + "\" as it is an instance of " + RenderService.class.getName()));
                        this.renderService = preferredRenderService;
                        returnCode = this.invokeRenderService(preferredRenderService, renderContext, object);
                    } else {
                        logger.info((Object)("Could not find an instance of " + RenderService.class.getName() + ", using bean: \"" + firstRenderService.getBeanName() + "\""));
                        this.renderService = firstRenderService;
                        returnCode = this.invokeRenderService(firstRenderService, renderContext, object);
                    }
                }
            }
            catch (RequestDispatchException e) {
                String msg = "A RequestDispatchException has been thrown whilst rendering " + this.getId() + " this is most likely because an error occurred during the rendering of an error page.";
                logger.error((Object)msg, (Throwable)e);
                this.pageContext.getOut().write(msg);
            }
        }
        return returnCode;
    }

    protected abstract int invokeRenderService(RenderService var1, RequestContext var2, ModelObject var3) throws Exception;
}

