/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.taglib;

import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.taglib.RenderServiceTag;

public class RegionTag
extends RenderServiceTag {
    private static final long serialVersionUID = 757901658987831411L;
    private String name = null;
    private String scope = null;
    private String access = null;
    private String chrome = null;
    private boolean chromeless = false;

    public void release() {
        super.release();
        this.name = null;
        this.scope = null;
        this.access = null;
        this.chrome = null;
        this.chromeless = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        if (this.scope == null) {
            this.scope = "global";
        }
        return this.scope;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getAccess() {
        return this.access;
    }

    public void setChrome(String chrome) {
        this.chrome = chrome;
    }

    public String getChrome() {
        return this.chrome;
    }

    public boolean isChromeless() {
        return this.chromeless;
    }

    public void setChromeless(boolean chromeless) {
        this.chromeless = chromeless;
    }

    @Override
    protected int invokeRenderService(RenderService renderService, RequestContext context, ModelObject object) throws RequestDispatchException {
        String templateId = context.getTemplateId();
        String overrideChrome = this.isChromeless() ? null : this.chrome;
        String scope = this.scope == null ? "global" : this.scope;
        renderService.renderRegion(context, RenderFocus.BODY, templateId, this.name, scope, overrideChrome, this.chromeless);
        return 0;
    }
}

