/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource.support;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.resource.AbstractResource;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.resource.ResourceContentImpl;
import org.springframework.extensions.surf.resource.ResourceJSONContent;
import org.springframework.extensions.surf.resource.ResourceJSONContentImpl;

public class AlfrescoResource
extends AbstractResource {
    private static Log logger = LogFactory.getLog(AlfrescoResource.class);
    private String objectTypeId = null;

    public AlfrescoResource(String protocolId, String endpointId, String objectId, FrameworkBean frameworkUtil) {
        super(protocolId, endpointId, objectId, frameworkUtil);
        if (objectId.indexOf(47) == -1) {
            throw new IllegalArgumentException("Resource URL of the format <protocolId>://<endpointId>/<objectId> for example: alfresco://alfresco-admin/workspace/SpacesStore/1234567890");
        }
    }

    @Override
    public ResourceContent getMetadata() throws IOException {
        return new ResourceJSONContentImpl(this, this.getMetadataURL(), this.frameworkUtil);
    }

    @Override
    public String getMetadataURL() {
        Object metadataURL = "/webframework/content/metadata";
        if (this.getObjectId() != null) {
            metadataURL = (String)metadataURL + "?id=" + this.getNodeRefId();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Alfresco Resource metadata URL: " + (String)metadataURL));
        }
        return metadataURL;
    }

    @Override
    public ResourceContent getContent() throws IOException {
        return new ResourceContentImpl(this, this.getContentURL(), this.frameworkUtil);
    }

    @Override
    public String getContentURL() {
        String contentURL = null;
        if (this.getObjectId() != null) {
            contentURL = "/api/node/" + this.getObjectId() + "/content";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Alfresco Resource content URL: " + contentURL));
        }
        return contentURL;
    }

    @Override
    public synchronized String getObjectTypeId() {
        if (this.objectTypeId == null) {
            JSONObject json = null;
            try {
                json = ((ResourceJSONContent)this.getMetadata()).getJSON();
                this.objectTypeId = json.getString("type");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.objectTypeId;
    }

    @Override
    public boolean isContainer() {
        boolean isContainer = false;
        try {
            ResourceJSONContent jsonContent = (ResourceJSONContent)this.getMetadata();
            isContainer = jsonContent.getJSON().getBoolean("isContainer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isContainer;
    }

    protected String getNodeRefId() {
        String nodeRefId = null;
        String objectId = this.getObjectId();
        if (objectId != null) {
            String workspaceId = null;
            String storeId = null;
            String nodeId = null;
            StringTokenizer tokenizer = new StringTokenizer(objectId, ":/");
            workspaceId = tokenizer.nextToken();
            storeId = tokenizer.nextToken();
            nodeId = tokenizer.nextToken();
            nodeRefId = workspaceId + "://" + storeId + "/" + nodeId;
        }
        return nodeRefId;
    }
}

