/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;

public class ResourceContentImpl
implements ResourceContent {
    protected final Resource resource;
    protected final String url;
    protected FrameworkBean frameworkUtil;

    public ResourceContentImpl(Resource resource, String url, FrameworkBean frameworkUtil) {
        this.resource = resource;
        this.url = url;
        this.frameworkUtil = frameworkUtil;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Reader getReader() throws IOException {
        Response response = this.getResponse();
        return new StringReader(response.getText());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Response response = this.getResponse();
        return response != null ? response.getResponseStream() : null;
    }

    @Override
    public String getStringContent() throws IOException {
        Response response = this.getResponse();
        return response != null ? response.getText() : null;
    }

    @Override
    public byte[] getBytes() throws IOException {
        Response response = this.getResponse();
        return response != null ? response.getText().getBytes(response.getEncoding()) : null;
    }

    private Response getResponse() throws IOException {
        Response response = null;
        String endpoint = this.resource.getEndpointId();
        if (endpoint == null) {
            endpoint = "http";
        }
        Connector connector = null;
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        try {
            connector = context == null ? this.frameworkUtil.getConnector(endpoint) : this.frameworkUtil.getConnector(context, endpoint);
        }
        catch (ConnectorServiceException cse) {
            throw new IOException("Unable to obtain connector to endpoint: " + endpoint);
        }
        if (connector != null) {
            ConnectorContext connectorContext = new ConnectorContext();
            connectorContext.setMethod(HttpMethod.GET);
            response = connector.call(this.url, connectorContext);
        }
        return response;
    }
}

