/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.ComponentRendererExecutionException;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.render.AbstractRenderer;
import org.springframework.extensions.surf.render.RenderFocus;
import org.springframework.extensions.surf.render.bean.ChromeRenderer;
import org.springframework.extensions.surf.types.Chrome;
import org.springframework.extensions.surf.types.Component;

public class ComponentRenderer
extends AbstractRenderer {
    private static final Log logger = LogFactory.getLog(ComponentRenderer.class);
    private ChromeRenderer chromeRenderer;

    public void setChromeRenderer(ChromeRenderer chromeRenderer) {
        this.chromeRenderer = chromeRenderer;
    }

    @Override
    public void header(RequestContext context, ModelObject object) throws RendererExecutionException {
        if (logger.isDebugEnabled()) {
            super.header(context, object);
        }
        Component component = (Component)object;
        try {
            this.getRenderService().processComponent(context, RenderFocus.HEADER, component, true);
        }
        catch (Exception ex) {
            throw new ComponentRendererExecutionException("Unable to render component: " + component.getId(), ex);
        }
    }

    @Override
    public void body(RequestContext context, ModelObject object) throws RendererExecutionException {
        Component component = (Component)object;
        Chrome chrome = (Chrome)context.getValue("component-chrome");
        Boolean chromeless = (Boolean)context.getValue("chromeless");
        try {
            if (!(chromeless != null && chromeless.booleanValue() || chrome == null)) {
                this.chromeRenderer.render(context, chrome, RenderFocus.BODY);
            } else {
                this.getRenderService().processComponent(context, RenderFocus.BODY, component, chromeless);
            }
            this.postProcess(context);
        }
        catch (Exception ex) {
            throw new ComponentRendererExecutionException("Unable to render component: " + component.getId(), ex);
        }
    }

    public void postProcess(RequestContext context) throws IOException {
    }
}

