/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.persister;

import org.dom4j.Document;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.ModelPersistenceContext;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.persister.PersisterService;

public abstract class AbstractObjectPersister
implements ModelObjectPersister,
BeanNameAware {
    protected static final Class<?>[] MODELOBJECT_CLASSES = new Class[]{String.class, ModelPersisterInfo.class, Document.class};
    private String id = null;
    private boolean isEnabled = true;
    private WebFrameworkConfigElement webFrameworkConfig;
    private PersisterService persisterService;
    private WebFrameworkServiceRegistry serviceRegistry;

    public void setBeanName(String name) {
        this.id = name;
    }

    @Override
    public void init(ModelPersistenceContext context) {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean removeObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.removeObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public boolean hasObject(ModelPersistenceContext context, ModelObject object) throws ModelObjectPersisterException {
        return this.hasObject(context, object.getTypeId(), object.getId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    protected void disable() {
        this.isEnabled = false;
    }

    public void setPersisterService(PersisterService persisterService) {
        this.persisterService = persisterService;
    }

    public void setWebFrameworkConfig(WebFrameworkConfigElement webFrameworkConfig) {
        this.webFrameworkConfig = webFrameworkConfig;
    }

    protected WebFrameworkConfigElement getWebFrameworkConfiguration() {
        if (this.webFrameworkConfig == null) {
            this.webFrameworkConfig = this.serviceRegistry.getWebFrameworkConfiguration();
        }
        return this.webFrameworkConfig;
    }

    protected PersisterService getPersisterService() {
        if (this.persisterService == null) {
            this.persisterService = this.serviceRegistry.getPersisterService();
        }
        return this.persisterService;
    }

    public void setServiceRegistry(WebFrameworkServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public WebFrameworkServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

