/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Map;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextFactory;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.exception.RequestDispatchException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkInterceptor;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class RequestContextInterceptor
extends AbstractWebFrameworkInterceptor {
    private Map<String, RequestContextFactory> factories = null;

    public void preHandle(WebRequest request) throws Exception {
        if (this.factories == null) {
            this.factories = this.getApplicationContext().getBeansOfType(RequestContextFactory.class);
        }
        RequestContextFactory factory = null;
        for (RequestContextFactory f : this.factories.values()) {
            if (!f.canHandle(request)) continue;
            factory = f;
            break;
        }
        if (factory != null) {
            try {
                factory.newInstance(request);
            }
            catch (RequestContextException rce) {
                throw new RequestDispatchException("Error while building request context", rce);
            }
        } else {
            throw new Exception("Unable to find a RequestContextFactory to handle request: " + String.valueOf(request));
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context != null) {
            context.release();
        }
        I18NUtil.setLocale(null);
    }
}

