/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.javascript.ErrorReporter;
import com.yahoo.platform.yui.javascript.EvaluatorException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.JavaScriptCompressionHandler;

public class YUIJavaScriptCompressorHandler
implements JavaScriptCompressionHandler {
    private static final Log logger = LogFactory.getLog(YUIJavaScriptCompressorHandler.class);
    private String charset = "UTF-8";
    private int linebreak = -1;
    private boolean munge = true;
    private boolean verbose = false;
    private boolean preserveAllSemiColons = false;
    private boolean disableOptimizations = false;

    @Override
    public void compress(Reader reader, Writer writer) throws IOException {
        JavaScriptCompressor jsc = new JavaScriptCompressor(reader, (ErrorReporter)new YuiCompressorErrorReporter());
        reader.close();
        jsc.compress(writer, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLinebreak(int linebreak) {
        this.linebreak = linebreak;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    private static class YuiCompressorErrorReporter
    implements ErrorReporter {
        private YuiCompressorErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.warn((Object)message);
            } else {
                logger.warn((Object)(line + ":" + lineOffset + ":" + message));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.error((Object)message);
            } else {
                logger.error((Object)(line + ":" + lineOffset + ":" + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

